% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_computed.R
\name{get_hori_data}
\alias{get_hori_data}
\title{Creating Temporary Parameters and \verb{<variable>.<parameter>} Variables}
\usage{
get_hori_data(dataset, by_vars, parameters, set_values_to, filter)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument are expected to be in the dataset.

\describe{
\item{Default value}{none}
}}

\item{by_vars}{Grouping variables

\describe{
\item{Default value}{none}
}}

\item{parameters}{List of parameter codes

The input dataset is restricted to the specified parameter codes. If an
expression is specified, a new parameter code is added to the input
dataset. The name of the element defines the parameter code and the
expression the observations to select.

\describe{
\item{Permitted values}{A character vector of \code{PARAMCD} values or a list of expressions}
\item{Default value}{none}
}}

\item{set_values_to}{All variables of the form \verb{<variable>.<parameter>} like \code{AVAL.WEIGHT} are
added to the input dataset. They are set to the value of the variable for
the parameter. E.g., \code{AVAL.WEIGHT} is set to the value of \code{AVAL} where
\code{PARAMCD == "WEIGHT"}.

\describe{
\item{Permitted values}{}
\item{Default value}{none}
}}

\item{filter}{Filter condition used for restricting the input dataset

The specified filter condition is used in the warnings only. It is not
applied to the input dataset.

\describe{
\item{Permitted values}{An unquoted expression}
\item{Default value}{none}
}}
}
\value{
A dataset with one observation per by group. It contains the
variables specified for \code{by_vars} and all variables of the form
\verb{<variable>.<parameter>} occurring in \code{set_values_to}.
}
\description{
The function creates temporary parameters and variables of the form
\verb{<variable>.<parameter>}, e.g., \code{AVAL.WEIGHT}.
}
\keyword{internal}
