% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{call_aval_fun}
\alias{call_aval_fun}
\title{Creates \code{AVAL} from \code{AVALC} by Calling User Function}
\usage{
call_aval_fun(dataset, aval_fun)
}
\arguments{
\item{dataset}{Input dataset

The variable \code{AVALC} is expected.

\emph{Permitted Values}: a dataframe}

\item{aval_fun}{Function returning the \code{AVALC} values

The specified function must expect one argument expecting a character
vector and must return a numeric vector.

\emph{Permitted Values}: a function}
}
\value{
The input dataset with \code{AVAL} added
}
\description{
Create \code{AVAL} from \code{AVALC} by calling a function provided by the user. If
calling the function fails, the error is caught and a helpful error message
provided.
}
\details{
The new variable \code{AVAL} is set to \code{aval_fun(AVALC)}.
}
\examples{

library(tibble)
library(dplyr)

data <- tribble(
  ~AVALC,
  "YES",
  "NO"
)

yn_map <- function(x) {
  case_when(
    x == "YES" ~ 1,
    x == "NO" ~ 0
  )
}

call_aval_fun(
  data,
  yn_map
)
}
\author{
Stefan Bundfuss
}
\concept{utils_catch}
\keyword{utils_catch}
