% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decontamin_density_unknownComp.R
\name{decontamin_density_unknownComp}
\alias{decontamin_density_unknownComp}
\title{Provide the decontaminated density of the unknown component in an admixture model}
\usage{
decontamin_density_unknownComp(sample1, comp.dist, comp.param, estim.p)
}
\arguments{
\item{sample1}{Observations of the first sample under study.}

\item{comp.dist}{A list with two elements corresponding to the component distributions (specified with R native names for these distributions)
involved in the admixture model. The two elements refer to the unknown and known components of the admixture model,
If there are unknown elements, they must be specified as 'NULL' objects (e.g. 'comp.dist' could be set to list(f1=NULL, g1='norm')).}

\item{comp.param}{A list with two elements corresponding to the parameters of the component distributions, each element being a list
itself. The names used in this list must correspond to the native R argument names for these distributions.
The two elements refer to the parameters of unknown and known components of the admixture model. If there are unknown
elements, they must be specified as 'NULL' objects (e.g. 'comp.param' could be set to list(f1=NULL, g1=list(mean=0,sd=1))).}

\item{estim.p}{The estimated weight of the unknown component distribution, related to the proportion of the unknown component
in the admixture model studied.}
}
\value{
A list containing the decontaminated density of the admixture model (of class 'function'),
and the support of the observations (either discrete or continuous).
}
\description{
Estimate the decontaminated density of the unknown component in the admixture model under study, after inversion of the admixture
cumulative distribution function. Recall that an admixture model follows the cumulative distribution function (CDF) L, where
L = p*F + (1-p)*G, with g a known CDF and p and f unknown quantities.
}
\details{
The decontaminated density is obtained by inverting the admixture density, given by l = p*f + (1-p)*g, to isolate the
unknown component f after having estimated p.
}
\examples{
## Simulate data:
list.comp <- list(f1 = 'norm', g1 = 'norm',
                  f2 = 'norm', g2 = 'norm')
list.param <- list(f1 = list(mean = 3, sd = 0.5), g1 = list(mean = 0, sd = 1),
                   f2 = list(mean = 3, sd = 0.5), g2 = list(mean = 5, sd = 2))
sample1 <- rsimmix(n=8000, unknownComp_weight=0.5, comp.dist = list(list.comp$f1,list.comp$g1),
                                                   comp.param=list(list.param$f1,list.param$g1))
sample2 <- rsimmix(n=7000, unknownComp_weight=0.7, comp.dist = list(list.comp$f2,list.comp$g2),
                                                   comp.param=list(list.param$f2,list.param$g2))
## Estimate the mixture weight in each of the sample in real-life setting:
list.comp <- list(f1 = NULL, g1 = 'norm',
                  f2 = NULL, g2 = 'norm')
list.param <- list(f1 = NULL, g1 = list(mean = 0, sd = 1),
                   f2 = NULL, g2 = list(mean = 5, sd = 2))
estimate <- IBM_estimProp(sample1[['mixt.data']], sample2[['mixt.data']], comp.dist = list.comp,
                          comp.param = list.param, with.correction = FALSE, n.integ = 1000)
## Determine the decontaminated version of the unknown density by inversion:
decontamin_density_unknownComp(sample1 = sample1[['mixt.data']],
                               comp.dist = list.comp[1:2], comp.param = list.param[1:2],
                               estim.p = estimate$prop.estim[1])
####### Discrete support:
list.comp <- list(f1 = 'pois', g1 = 'pois',
                  f2 = 'pois', g2 = 'pois')
list.param <- list(f1 = list(lambda = 3), g1 = list(lambda = 2),
                   f2 = list(lambda = 3), g2 = list(lambda = 4))
sample1 <- rsimmix(n=7000, unknownComp_weight=0.6, comp.dist = list(list.comp$f1,list.comp$g1),
                                                   comp.param=list(list.param$f1,list.param$g1))
sample2 <- rsimmix(n=6000, unknownComp_weight=0.8, comp.dist = list(list.comp$f2,list.comp$g2),
                                                   comp.param=list(list.param$f2,list.param$g2))
## Estimate the mixture weight in each of the sample in real-life setting:
list.comp <- list(f1 = NULL, g1 = 'pois',
                  f2 = NULL, g2 = 'pois')
list.param <- list(f1 = NULL, g1 = list(lambda = 2),
                   f2 = NULL, g2 = list(lambda = 4))
estimate <- IBM_estimProp(sample1[['mixt.data']], sample2[['mixt.data']], comp.dist = list.comp,
                          comp.param = list.param, with.correction = FALSE, n.integ = 1000)
## Determine the decontaminated version of the unknown density by inversion:
decontamin_density_unknownComp(sample1 = sample1[['mixt.data']],
                               comp.dist = list.comp[1:2], comp.param = list.param[1:2],
                               estim.p = estimate$prop.estim[1])
####### Finite discrete support:
list.comp <- list(f1 = 'multinom', g1 = 'multinom',
                  f2 = 'multinom', g2 = 'multinom')
list.param <- list(f1 = list(size=1, prob=c(0.3,0.4,0.3)), g1 = list(size=1, prob=c(0.6,0.3,0.1)),
                   f2 = list(size=1, prob=c(0.3,0.4,0.3)), g2 = list(size=1, prob=c(0.2,0.6,0.2)))
sample1 <- rsimmix(n=12000, unknownComp_weight=0.6, comp.dist = list(list.comp$f1,list.comp$g1),
                                                   comp.param=list(list.param$f1,list.param$g1))
sample2 <- rsimmix(n=10000, unknownComp_weight=0.8, comp.dist = list(list.comp$f2,list.comp$g2),
                                                   comp.param=list(list.param$f2,list.param$g2))
## Estimate the mixture weight in each of the sample in real-life setting:
list.comp <- list(f1 = NULL, g1 = 'multinom',
                  f2 = NULL, g2 = 'multinom')
list.param <- list(f1 = NULL, g1 = list(size=1, prob=c(0.6,0.3,0.1)),
                   f2 = NULL, g2 = list(size=1, prob=c(0.2,0.6,0.2)))
estimate <- IBM_estimProp(sample1[['mixt.data']], sample2[['mixt.data']], comp.dist = list.comp,
                          comp.param = list.param, with.correction = FALSE, n.integ = 1000)
## Determine the decontaminated version of the unknown density by inversion:
decontamin_density_unknownComp(sample1 = sample1[['mixt.data']],
                               comp.dist = list.comp[1:2], comp.param = list.param[1:2],
                               estim.p = estimate$prop.estim[1])

}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
