# admixr 0.9.1

* Added executable examples to each function.

# admixr 0.9.0

* New prototype implementation of exhaustive search of qpAdm models
  through rotation of sources and outgroups (`qpAdm_rotation()`).
* New tutorial describing the `qpAdm_rotation()` procedure.
* Fixed broken regex parsing of qpWave log files in some cases.
* Added type checking to a couple of functions (not all wrappers type
  checked yet).

# admixr 0.8.7

* qpAdm proportions table now shows p-values and SNP counts (both for
  overall analysis but also for the target sample).

# admixr 0.8.6

* Satisfying further checks on various testing servers.

# admixr 0.8.5

* Cleaned up build procedure.

# admixr 0.8.4

* Fixed imports.

# admixr 0.8.3

* Updated license.

# admixr 0.8.2

* Expanded some tests.
* Prepared for the first CRAN submission.

# admixr 0.8.1

* Fixed a minor bug in single-source qpAdm analyses. The package now
  detects this and correctly handles missing "subsets/patterns"
  information.

# admixr 0.8.0

Finally resumed the development of _admixr_! Apologies to everyone for
having to wait so long. Thank you for your patience and feedback since
the last release. I hope that things will start moving a little bit
faster and we will reach version 1.0 in the next couple of months.

New features and improvements:

* New function `loginfo()` which operates on any output object from an
  admixr wrapper and shows the full log output (the "log file" in
  ADMIXTOOLS jargon) associated with the analysis. It also has options
  for saving the log file to a permanent location and to only show a
  log file for a target sample of interest (relevant for _qpAdm_
  analyses with multiple targets at once).
* _admixr_ can now (hopefully) detect broken/truncated output files
  generated by ADMIXTOOLS whenever there is some fatal issue with an
  analysis.  The package should now detect this and inform the user.
* Removed _qpAdm_ argument `details` - the user will always want to
  see the full analysis summary so this option is redundant. It is
  still kept in _qpWave_ - for now, until I figure out how useful the
  full output actually is.  Given the implementation of `loginfo()`
  above, we might remove the argument from _qpWave_ too at some point
  soon.
* The function `download_data()` now fetches data from a more stable
  location.

# admixr 0.7.1

* Parse admixture proportions from the "best coefficients" line of the
  qpAdm output file.

# admixr 0.7.0

* Fixed handling of warnings when dealing with duplicated populations.
* 9s are now replaced with NAs in `read_geno()` and `write_geno()`,
  which makes it more convenient to write custom analytic code working
  on data.frames.
* Renamed `qpAdm()` output elements and changed its function
  signature.

# admixr 0.6.3

* Rename `keep_transversions()` to `transversions_only()`. The old
  function is now deprecated.
* `print.EIGENSTRAT()` now uses a pre-calculated numbers of
  removed/remaining sites, instead of calculating them each and every
  time.
* Printing EIGENSTRAT objects now also shows "group" and "exclude"
  modifiers only if present.

# admixr 0.6.2

* `read_output()` made public.
* Fixed issues with parsing of mis-formatted ind files (tabs at the
  ends of lines etc.).

# admixr 0.6.1

* It turned out that dragging along Rcpp and Boost dependencies just
  for the VCF -> EIGENSTRAT conversion function causes unnecessary
  complications in the installation process. It's not worth having it
  in the package if it would be used only by a small fraction of
  potential users.

  This function has been removed and the `vcf2eigenstrat` program is
  maintained in its own repository.

# admixr 0.6.0

* Conversion of VCF to EIGENSTRAT format is now implemented in C++ and
  should be approximately infinitely faster than the old conversion
  function written in pure R.
* Conversion of EIGENSTRAT _into_ VCF has been removed.

# admixr 0.5.0

* Added full implementations of `qpWave()` and `qpAdm()` functions.
* `filter_bed()` now implemented simply by calling `bedtools` in the
  background.  This turned out to be way faster and memory efficient
  than the previous data.table-based solution.

# admixr 0.4.1

* Fixed missing `group_labels()` update.
* Removed the huge built-in data set. Implemented `download_data()`
  function that fetches the example data set from the web.

# admixr 0.4.0

* The package now has a tutorial vignette describing the main
  functionality.
* Simple SNP dataset is now included with the package.
* The API of many utility functions has been simplified and their
  internals re-written.
* `filter_sites` is now implemented using `data.table` and allows
  overlap with an arbitrary BED file.

# admixr 0.3.0

* All wrappers have been given simpler names (`qpDstat()` -> `d()`,
  `qpF4ratio()` -> `f4ratio()`, etc).
* F4 statistic can now be calculated using a separate `f4()` function
  (`f4mode` parameter remains in the `d()` function though, as `f4()`
  calls `d()` internally).
* All tests are performed on Travis CI using installed and compiled
  ADMIXTOOLS software.

# admixr 0.2.0

* The package now includes qpAdm functionality.

* Formal tests for all implemented wrapper functions have been
  implemented.

# admixr 0.1.0

Implemented:

* D statistic as qpDstat,
* f4 statistic as qpDstat(f4mode = TRUE),
* f4-ratio statistic as qpF4Ratio,
* f3 statistic as qp3Pop.
