% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigenstrat.R
\name{reset}
\alias{reset}
\title{Reset modifications to an EIGENSTRAT object}
\usage{
reset(data)
}
\arguments{
\item{data}{EIGENSTRAT data object.}
}
\value{
EIGENSTRAT data S3 object.
}
\description{
Set 'exclude' and 'group' modifications of snp and ind files, effectively
resetting the dataset into its original state.
}
\examples{
\dontrun{# download an example genomic data set and prepare it for analysis
snps <- eigenstrat(download_data(dirname = tempdir()))

# group individual samples into larger populations, creating a new
# EIGENSTRAT R object
new_snps <- relabel(
    snps,
    European = c("French", "Sardinian"),
    African = c("Dinka", "Yoruba", "Mbuti", "Khomani_San"),
    Archaic = c("Vindija", "Altai", "Denisova")
)

# remove the population grouping in the previous step - this
# results in the same EIGENSTRAT object tht we started with
original_snps <- reset(new_snps)
}

}
