% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{Constraints}
\alias{Constraints}
\alias{evaluate,Constraint,TwoStageDesign-method}
\alias{<=,ConditionalScore,numeric-method}
\alias{>=,ConditionalScore,numeric-method}
\alias{<=,numeric,ConditionalScore-method}
\alias{>=,numeric,ConditionalScore-method}
\alias{<=,ConditionalScore,ConditionalScore-method}
\alias{>=,ConditionalScore,ConditionalScore-method}
\alias{<=,UnconditionalScore,numeric-method}
\alias{>=,UnconditionalScore,numeric-method}
\alias{<=,numeric,UnconditionalScore-method}
\alias{>=,numeric,UnconditionalScore-method}
\alias{<=,UnconditionalScore,UnconditionalScore-method}
\alias{>=,UnconditionalScore,UnconditionalScore-method}
\title{Formulating Constraints}
\usage{
\S4method{evaluate}{Constraint,TwoStageDesign}(s, design, optimization = FALSE, ...)

\S4method{<=}{ConditionalScore,numeric}(e1, e2)

\S4method{>=}{ConditionalScore,numeric}(e1, e2)

\S4method{<=}{numeric,ConditionalScore}(e1, e2)

\S4method{>=}{numeric,ConditionalScore}(e1, e2)

\S4method{<=}{ConditionalScore,ConditionalScore}(e1, e2)

\S4method{>=}{ConditionalScore,ConditionalScore}(e1, e2)

\S4method{<=}{UnconditionalScore,numeric}(e1, e2)

\S4method{>=}{UnconditionalScore,numeric}(e1, e2)

\S4method{<=}{numeric,UnconditionalScore}(e1, e2)

\S4method{>=}{numeric,UnconditionalScore}(e1, e2)

\S4method{<=}{UnconditionalScore,UnconditionalScore}(e1, e2)

\S4method{>=}{UnconditionalScore,UnconditionalScore}(e1, e2)
}
\arguments{
\item{s}{\code{\link[=Scores]{Score}} object}

\item{design}{object}

\item{optimization}{logical, if \code{TRUE} uses a relaxation to real
parameters of the underlying design; used for smooth optimization.}

\item{...}{further optional arguments}

\item{e1}{left hand side (score or numeric)}

\item{e2}{right hand side (score or numeric)}
}
\description{
Conceptually, constraints work very similar to scores (any score can be put in
a constraint).
Currently,  constraints of the form 'score <=/>= x',
'x <=/>= score' and 'score <=/>= score' are admissible.
}
\examples{
design <- OneStageDesign(50, 1.96)

cp     <- ConditionalPower(Normal(), PointMassPrior(0.4, 1))
pow    <- Power(Normal(), PointMassPrior(0.4, 1))

# unconditional power constraint
constraint1 <- pow >= 0.8
evaluate(constraint1, design)

# conditional power constraint
constraint2 <- cp  >= 0.7
evaluate(constraint2, design, .5)
constraint3 <- 0.7 <= cp # same as constraint2
evaluate(constraint3, design, .5)

}
\seealso{
\code{\link{minimize}}
}
