% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angle.r
\name{as_angle}
\alias{as_angle}
\alias{as_angle.angle}
\alias{as_angle.character}
\alias{as_angle.complex}
\alias{as_angle.Coord2D}
\alias{as_angle.Coord3D}
\alias{as_angle.Line2D}
\alias{as_angle.Plane3D}
\alias{as_angle.numeric}
\title{Cast to angle vector}
\usage{
as_angle(x, unit = getOption("affiner_angular_unit", "degrees"), ...)

\method{as_angle}{angle}(x, unit = getOption("affiner_angular_unit", "degrees"), ...)

\method{as_angle}{character}(x, unit = getOption("affiner_angular_unit", "degrees"), ...)

\method{as_angle}{complex}(x, unit = getOption("affiner_angular_unit", "degrees"), ...)

\method{as_angle}{Coord2D}(x, unit = getOption("affiner_angular_unit", "degrees"), ...)

\method{as_angle}{Coord3D}(
  x,
  unit = getOption("affiner_angular_unit", "degrees"),
  type = c("azimuth", "inclination"),
  ...
)

\method{as_angle}{Line2D}(x, unit = getOption("affiner_angular_unit", "degrees"), ...)

\method{as_angle}{Plane3D}(
  x,
  unit = getOption("affiner_angular_unit", "degrees"),
  type = c("azimuth", "inclination"),
  ...
)

\method{as_angle}{numeric}(x, unit = getOption("affiner_angular_unit", "degrees"), ...)
}
\arguments{
\item{x}{An R object to convert to a \code{\link[=angle]{angle()}} vector}

\item{unit}{A string of the desired angular unit.  Supports the following strings
(note we ignore any punctuation and space characters as well as any trailing \code{s}'s
e.g. "half turns" will be treated as equivalent to "halfturn"):
\itemize{
\item "deg" or "degree"
\item "half-revolution", "half-turn", or "pi-radian"
\item "gon", "grad", "grade", or "gradian"
\item "rad" or "radian"
\item "rev", "revolution", "tr", or "turn"
}}

\item{...}{Further arguments passed to or from other methods}

\item{type}{Use "azimuth" to calculate the azimuthal angle and "inclination" to calculate the inclination angle aka polar angle.}
}
\value{
An \code{\link[=angle]{angle()}} vector
}
\description{
\code{as_angle()} casts to an \code{\link[=angle]{angle()}} vector
}
\examples{
as_angle(angle(pi, "radians"), "pi-radians")
as_angle(complex(real = 0, imaginary = 1), "degrees")
as_angle(as_coord2d(x = 0, y = 1), "turns")
as_angle(200, "gradians")

}
