% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afmIndentation.R
\name{afmIndentation}
\alias{afmIndentation}
\title{afmIndentation}
\usage{
afmIndentation(afmdata)
}
\arguments{
\item{afmdata}{An \code{afmdata} object. It should be a valid afmdata
object upon which the Contact Point, the baseline correction and the Zero 
Force Point must have been calculated first (using functions 
\code{afmContactPoint()}, \code{afmBaselineCorrection()}) and
 \code{afmZeroPointSlope()}}
}
\value{
Returns a list with one field:

\code{afmdata}: An afmdata class in which a \code{Indentation} column is added 
in the \code{data} field.
}
\description{
This function computes the deformation of the sample from the 
calibrated Force-Distance curve, by substracting Z to the Zero Force Point 
calculated with afmZeroPointSlope function.
}
\examples{
data <- afmReadJPK("force-save-JPK-3h.txt.gz", path = path.package("afmToolkit"))
data <- afmContactPoint(data, width = 20, mul1 = 1, mul2 = 20)
data <- afmDetachPoint(data, width = 40, mul1 = 3, mul2 = 40)
data <- afmBaselineCorrection(data)
data <- afmZeroPointSlope(data, segment = "approach")
data <- afmIndentation(data)
head(data$data)
}

