% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-aghq.R
\name{print.aghqsummary}
\alias{print.aghqsummary}
\title{Print method for AGHQ summary objects}
\usage{
\method{print}{aghqsummary}(x, ...)
}
\arguments{
\item{x}{The result of calling \code{summary(...)} on an object of class \code{aghq}.}

\item{...}{not used.}
}
\value{
Silently prints summary information.
}
\description{
Print the summary of an \code{aghq} object. Almost always called by invoking
\code{summary(...)} interactively in the console.
}
\examples{

logfteta2d <- function(eta,y) {
  # eta is now (eta1,eta2)
  # y is now (y1,y2)
  n <- length(y)
  n1 <- ceiling(n/2)
  n2 <- floor(n/2)
  y1 <- y[1:n1]
  y2 <- y[(n1+1):(n1+n2)]
  eta1 <- eta[1]
  eta2 <- eta[2]
  sum(y1) * eta1 - (length(y1) + 1) * exp(eta1) - sum(lgamma(y1+1)) + eta1 +
    sum(y2) * eta2 - (length(y2) + 1) * exp(eta2) - sum(lgamma(y2+1)) + eta2
}
set.seed(84343124)
n1 <- 5
n2 <- 5
n <- n1+n2
y1 <- rpois(n1,5)
y2 <- rpois(n2,5)
objfunc2d <- function(x) logfteta2d(x,c(y1,y2))
funlist2d <- list(
  fn = objfunc2d,
  gr = function(x) numDeriv::grad(objfunc2d,x),
  he = function(x) numDeriv::hessian(objfunc2d,x)
)

thequadrature <- aghq(funlist2d,3,c(0,0))
# Summarize and automatically call its print() method when called interactively:
summary(thequadrature)

}
\seealso{
Other quadrature: 
\code{\link{aghq}()},
\code{\link{laplace_approximation}()},
\code{\link{marginal_laplace}()},
\code{\link{normalize_logpost}()},
\code{\link{optimize_theta}()},
\code{\link{plot.aghq}()},
\code{\link{print.aghq}()},
\code{\link{print.laplacesummary}()},
\code{\link{print.laplace}()},
\code{\link{summary.aghq}()},
\code{\link{summary.laplace}()}

Other quadrature: 
\code{\link{aghq}()},
\code{\link{laplace_approximation}()},
\code{\link{marginal_laplace}()},
\code{\link{normalize_logpost}()},
\code{\link{optimize_theta}()},
\code{\link{plot.aghq}()},
\code{\link{print.aghq}()},
\code{\link{print.laplacesummary}()},
\code{\link{print.laplace}()},
\code{\link{summary.aghq}()},
\code{\link{summary.laplace}()}
}
\concept{quadrature}
