% Generated by roxygen2 (4.0.1): do not edit by hand
\name{pareto2_estimate_mle}
\alias{pareto2_estimate_mle}
\title{Parameter Estimation in the Pareto-II Distribution (MLE)}
\usage{
pareto2_estimate_mle(x, s = NA_real_, smin = 1e-04, smax = 20,
  tol = .Machine$double.eps^0.25)
}
\arguments{
\item{x}{a non-negative numeric vector}

\item{s}{a-priori known scale parameter, \eqn{s>0} or
\code{NA} if unknown (default)}

\item{smin}{lower bound for the scale parameter to look for}

\item{smax}{upper bound for the scale parameter to look for}

\item{tol}{the desired accuracy (convergence tolerance)}
}
\value{
a numeric vector  with the following named components:
\itemize{
\item \code{k} - estimated parameter of shape
\item \code{s} - estimated (or known, see the \code{s} argument) parameter of scale
}
or \code{c(NA, NA)} if the maximum of the likelihood function
could not be found.
}
\description{
Finds the maximum likelihood estimator of the type II Pareto distribution's
shape parameter \eqn{k} and, if not given explicitly,
 scale parameter \eqn{s}.
}
\details{
Note that if \eqn{s} is not given, then
the maximum of the likelihood function may not exist
for some input vectors. This estimator may have large mean squared error.
Consider using \code{\link{pareto2_estimate_mmse}}.

For known \eqn{s}, the estimator is unbiased.
}
\seealso{
Other Pareto2: \code{\link{dpareto2}},
  \code{\link{ppareto2}}, \code{\link{qpareto2}},
  \code{\link{rpareto2}};
  \code{\link{pareto2_estimate_mmse}};
  \code{\link{pareto2_test_f}}
}

