% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel-symmetry.R
\name{rel_is_symmetric}
\alias{rel_is_symmetric}
\alias{rel_closure_symmetric}
\title{Symmetric Binary Relations}
\usage{
rel_is_symmetric(R)

rel_closure_symmetric(R)
}
\arguments{
\item{R}{an object coercible to a 0-1 (logical) square matrix,
representing a binary relation on a finite set.}
}
\value{
The \code{rel_closure_symmetric} function
returns a logical square matrix. \code{\link{dimnames}}
of \code{R} are preserved.

On the other hand, \code{rel_is_symmetric} returns
a single logical value.
}
\description{
A binary relation \eqn{R} is \emph{symmetric}, iff
for all \eqn{x, y} we have \eqn{xRy} \eqn{\Rightarrow}{=>} \eqn{yRx}.
}
\details{
\code{rel_is_symmetric} finds out if a given binary relation
is symmetric. Any missing value behind the diagonal results in \code{NA}.

The \emph{symmetric closure} of a binary relation \eqn{R},
determined by \code{rel_closure_symmetric},
is the smallest symmetric binary relation that contains \eqn{R}.
Here, any missing values in \code{R} result in an error.
}
\seealso{
Other binary_relations: \code{\link{check_comonotonicity}},
  \code{\link{pord_nd}}, \code{\link{pord_spread}},
  \code{\link{pord_weakdom}}, \code{\link{rel_graph}},
  \code{\link{rel_is_antisymmetric}},
  \code{\link{rel_is_asymmetric}},
  \code{\link{rel_is_cyclic}},
  \code{\link{rel_is_irreflexive}},
  \code{\link{rel_is_reflexive}},
  \code{\link{rel_is_total}},
  \code{\link{rel_is_transitive}},
  \code{\link{rel_reduction_hasse}}
}
\concept{binary_relations}
