% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahn_main.R
\name{plot.ahn}
\alias{plot.ahn}
\title{Plot Artificial Hydrocarbon Network}
\usage{
\method{plot}{ahn}(x, ...)
}
\arguments{
\item{x}{an object of class "\code{ahn}" produced from the \link{fit} function.}

\item{...}{further arguments passed to visNetwork functions.}
}
\value{
dynamic visualization of the AHN.
}
\description{
Plot method for objects of class \code{ahn}.
}
\examples{
\dontrun{
# Create data
x <- 2 * runif(1000) - 1;
x <- sort(x)

y <- (x < 0.1) * (0.05 * runif(100) + atan(pi*x)) +
    (x >= 0.1 & x < 0.6) * (0.05 * runif(1000) + sin(pi*x)) +
    (x >= 0.6) * (0.05 * runif(1000) + cos(pi*x))

# Create Sigma list
Sigma <- list(X = data.frame(x = x), Y = data.frame(y = y))

# Train AHN
ahn <- fit(Sigma, 5, 0.01, 500)

# Plot AHN
plot(ahn)
}

}
