% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahp_harker.R
\name{ahp.harker}
\alias{ahp.harker}
\title{Replace inconsistent pairwise comparisons}
\usage{
ahp.harker(ahpmat, atts, round = FALSE, limit = FALSE,
  iterations = 1, stopcr = 0, printiter = TRUE)
}
\arguments{
\item{ahpmat}{A list of pairwise comparison matrices of each decision maker generated by \code{ahp.mat}.}

\item{atts}{A list of attributes in the correct order}

\item{round}{Rounds the imputation values of the matrix to the nearest integer if \code{TRUE}. Defaults to \code{FALSE}.}

\item{limit}{If set to \code{TRUE}, if the imputation value is larger than 9 or smaller than 1/9, the value is converted to 9 and 1/9 respectively. Defaults to \code{FALSE}.}

\item{iterations}{The number of comparisons with the highest inconsistency to be changed. For example, if \code{iterations = 3}, \code{ahp.harker} changes the first, second, and third most inconsistent pairwise comparisons using that method. Defaults to \code{1}.}

\item{stopcr}{The stopping Consistency Ratio, which was calculated by \code{ahp.cr}. Complements \code{iter} by giving \code{iterations} a criteria to stop when a matrix is sufficiently consistent. The function will continue looping and replacing more elements of the pairwise comparison matrices until the consistency ratio of the new matrix is lower than \code{stopcr}, or the maximum number of iterations is reached, and will stop and move onto the next individual. When \code{stopcr} is set, the number of replaced elements will differ among each decision-maker. Defaults to \code{0} (i.e. the loop will not be stopped unless \code{iterations} is reached)}

\item{printiter}{Whether the number of iterations taken for each pairwise matrix is reported or not. If \code{printiter = TRUE}, it prints out the final number of iterations that each individual decision-maker took to reach a value lower than \code{stopcr}. Generally it is not needed if \code{stopcr} is not specified. When \code{stopcr} is specified, this is a good way of identifying how many pairwise comparisons are actually replaced by the algorithm for each decision maker. Defaults to \code{TRUE}.}
}
\value{
A list of matrices with values replaced with consistent values.
}
\description{
Based on the matrix derived from \code{ahp.error}, replaces the top \code{n} number of inconsistent pairwise comparisons with a value calculated by from the method in \insertCite{Harker1987;textual}{ahpsurvey}. While there are strong arguments against replacing inconsistent values without the decision-maker's consent for the sake of satisfying the consistency ratio criterion of consistency ratio < 0.1 (see \insertCite{Saaty2007fuzzy;textual}{ahpsurvey}), it is often not possible for enumerators to ask respondents to change their answers based on consistency, whereas truncating inconsistent decisions may make the dataset unrepresentative of the population. Researchers should think carefully and explain fully the methods used to process AHP data, and whenever possible, use a lower number of iterations.
}
\examples{

atts <- c('cult', 'fam', 'house', 'jobs', 'trans')

data(city200)

cityahp <- ahp.mat(city200, atts, negconvert = TRUE)
ahp.harker(cityahp, atts)

}
\references{
\insertAllCited{}
}
\seealso{
ahp.error ahp.cr
}
\author{
Frankie Cho
}
