% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obj_TEClassifierProtoNet.R
\name{TEClassifierProtoNet}
\alias{TEClassifierProtoNet}
\title{Text embedding classifier with a ProtoNet}
\value{
Objects of this class are used for assigning texts to classes/categories. For the creation and training of a
classifier an object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings} and a \code{factor} are necessary. The
object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings} contains the numerical text representations (text
embeddings) of the raw texts generated by an object of class \link{TextEmbeddingModel}. The \code{factor} contains the
classes/categories for every text. Missing values (unlabeled cases) are supported. For predictions an object of
class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings} has to be used which was created with the same
\link{TextEmbeddingModel} as for training.
}
\description{
Abstract class for neural nets with 'pytorch'.

This class is \strong{deprecated}. Please use an Object of class \link{TEClassifierSequentialPrototype} instead.

This object represents in implementation of a prototypical network for few-shot learning as described by Snell,
Swersky, and Zemel (2017). The network uses a multi way contrastive loss described by Zhang et al. (2019). The
network learns to scale the metric as described by Oreshkin, Rodriguez, and Lacoste (2018)
}
\note{
This model requires \code{pad_value=0}. If this condition is not met the
padding value is switched automatically.
}
\references{
Oreshkin, B. N., Rodriguez, P. & Lacoste, A. (2018). TADAM: Task dependent adaptive metric for improved
few-shot learning. https://doi.org/10.48550/arXiv.1805.10123

Snell, J., Swersky, K. & Zemel, R. S. (2017). Prototypical Networks for Few-shot Learning.
https://doi.org/10.48550/arXiv.1703.05175

Zhang, X., Nie, J., Zong, L., Yu, H. & Liang, W. (2019). One Shot Learning with Margin. In Q. Yang, Z.-H.
Zhou, Z. Gong, M.-L. Zhang & S.-J. Huang (Eds.), Lecture Notes in Computer Science. Advances in Knowledge Discovery
and Data Mining (Vol. 11440, pp. 305–317). Springer International Publishing.
https://doi.org/10.1007/978-3-030-16145-3_24
}
\seealso{
Other Classification: 
\code{\link{TEClassifierParallel}},
\code{\link{TEClassifierParallelPrototype}},
\code{\link{TEClassifierRegular}},
\code{\link{TEClassifierSequential}},
\code{\link{TEClassifierSequentialPrototype}}
}
\concept{Classification}
\section{Super classes}{
\code{\link[aifeducation:AIFEBaseModel]{aifeducation::AIFEBaseModel}} -> \code{\link[aifeducation:ModelsBasedOnTextEmbeddings]{aifeducation::ModelsBasedOnTextEmbeddings}} -> \code{\link[aifeducation:ClassifiersBasedOnTextEmbeddings]{aifeducation::ClassifiersBasedOnTextEmbeddings}} -> \code{\link[aifeducation:TEClassifiersBasedOnProtoNet]{aifeducation::TEClassifiersBasedOnProtoNet}} -> \code{TEClassifierProtoNet}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TEClassifierProtoNet-new}{\code{TEClassifierProtoNet$new()}}
\item \href{#method-TEClassifierProtoNet-configure}{\code{TEClassifierProtoNet$configure()}}
\item \href{#method-TEClassifierProtoNet-embed}{\code{TEClassifierProtoNet$embed()}}
\item \href{#method-TEClassifierProtoNet-plot_embeddings}{\code{TEClassifierProtoNet$plot_embeddings()}}
\item \href{#method-TEClassifierProtoNet-clone}{\code{TEClassifierProtoNet$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="count_parameter"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-count_parameter'><code>aifeducation::AIFEBaseModel$count_parameter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_all_fields"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_all_fields'><code>aifeducation::AIFEBaseModel$get_all_fields()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_documentation_license"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_documentation_license'><code>aifeducation::AIFEBaseModel$get_documentation_license()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_ml_framework"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_ml_framework'><code>aifeducation::AIFEBaseModel$get_ml_framework()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_model_description"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_model_description'><code>aifeducation::AIFEBaseModel$get_model_description()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_model_info"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_model_info'><code>aifeducation::AIFEBaseModel$get_model_info()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_model_license"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_model_license'><code>aifeducation::AIFEBaseModel$get_model_license()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_package_versions"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_package_versions'><code>aifeducation::AIFEBaseModel$get_package_versions()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_private"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_private'><code>aifeducation::AIFEBaseModel$get_private()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_publication_info"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_publication_info'><code>aifeducation::AIFEBaseModel$get_publication_info()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_sustainability_data"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_sustainability_data'><code>aifeducation::AIFEBaseModel$get_sustainability_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="is_configured"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-is_configured'><code>aifeducation::AIFEBaseModel$is_configured()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="is_trained"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-is_trained'><code>aifeducation::AIFEBaseModel$is_trained()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="load"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-load'><code>aifeducation::AIFEBaseModel$load()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="set_documentation_license"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-set_documentation_license'><code>aifeducation::AIFEBaseModel$set_documentation_license()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="set_model_description"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-set_model_description'><code>aifeducation::AIFEBaseModel$set_model_description()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="set_model_license"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-set_model_license'><code>aifeducation::AIFEBaseModel$set_model_license()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="set_publication_info"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-set_publication_info'><code>aifeducation::AIFEBaseModel$set_publication_info()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ModelsBasedOnTextEmbeddings" data-id="get_text_embedding_model"><a href='../../aifeducation/html/ModelsBasedOnTextEmbeddings.html#method-ModelsBasedOnTextEmbeddings-get_text_embedding_model'><code>aifeducation::ModelsBasedOnTextEmbeddings$get_text_embedding_model()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ModelsBasedOnTextEmbeddings" data-id="get_text_embedding_model_name"><a href='../../aifeducation/html/ModelsBasedOnTextEmbeddings.html#method-ModelsBasedOnTextEmbeddings-get_text_embedding_model_name'><code>aifeducation::ModelsBasedOnTextEmbeddings$get_text_embedding_model_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="adjust_target_levels"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-adjust_target_levels'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$adjust_target_levels()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="check_embedding_model"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-check_embedding_model'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$check_embedding_model()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="check_feature_extractor_object_type"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-check_feature_extractor_object_type'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$check_feature_extractor_object_type()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="load_from_disk"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-load_from_disk'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$load_from_disk()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="plot_coding_stream"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-plot_coding_stream'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$plot_coding_stream()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="plot_training_history"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-plot_training_history'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$plot_training_history()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="predict"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-predict'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="requires_compression"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-requires_compression'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$requires_compression()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="save"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-save'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="TEClassifiersBasedOnProtoNet" data-id="get_metric_scale_factor"><a href='../../aifeducation/html/TEClassifiersBasedOnProtoNet.html#method-TEClassifiersBasedOnProtoNet-get_metric_scale_factor'><code>aifeducation::TEClassifiersBasedOnProtoNet$get_metric_scale_factor()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="TEClassifiersBasedOnProtoNet" data-id="predict_with_samples"><a href='../../aifeducation/html/TEClassifiersBasedOnProtoNet.html#method-TEClassifiersBasedOnProtoNet-predict_with_samples'><code>aifeducation::TEClassifiersBasedOnProtoNet$predict_with_samples()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="TEClassifiersBasedOnProtoNet" data-id="train"><a href='../../aifeducation/html/TEClassifiersBasedOnProtoNet.html#method-TEClassifiersBasedOnProtoNet-train'><code>aifeducation::TEClassifiersBasedOnProtoNet$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifierProtoNet-new"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifierProtoNet-new}{}}}
\subsection{Method \code{new()}}{
Creating a new instance of this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifierProtoNet$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns an object of class \link{TEClassifierProtoNet} which is ready for configuration.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifierProtoNet-configure"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifierProtoNet-configure}{}}}
\subsection{Method \code{configure()}}{
Creating a new instance of this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifierProtoNet$configure(
  name = NULL,
  label = NULL,
  text_embeddings = NULL,
  feature_extractor = NULL,
  target_levels = NULL,
  dense_size = 4,
  dense_layers = 0,
  rec_size = 4,
  rec_layers = 2,
  rec_type = "GRU",
  rec_bidirectional = FALSE,
  embedding_dim = 2,
  self_attention_heads = 0,
  intermediate_size = NULL,
  attention_type = "Fourier",
  add_pos_embedding = TRUE,
  act_fct = "ELU",
  parametrizations = "None",
  rec_dropout = 0.1,
  repeat_encoder = 1,
  dense_dropout = 0.4,
  encoder_dropout = 0.1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\code{string} Name of the new model. Please refer to common name conventions.
Free text can be used with parameter \code{label}. If set to \code{NULL} a unique ID
is generated automatically. Allowed values: any}

\item{\code{label}}{\code{string} Label for the new model. Here you can use free text. Allowed values: any}

\item{\code{text_embeddings}}{\verb{EmbeddedText, LargeDataSetForTextEmbeddings} Object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings}.}

\item{\code{feature_extractor}}{\code{TEFeatureExtractor} Object of class \link{TEFeatureExtractor} which should be used in order to reduce
the number of dimensions of the text embeddings. If no feature extractor should be applied set \code{NULL}.}

\item{\code{target_levels}}{\code{vector} containing the levels (categories or classes) within the target data. Please
note that order matters. For ordinal data please ensure that the levels are sorted correctly with later levels
indicating a higher category/class. For nominal data the order does not matter.}

\item{\code{dense_size}}{\code{int} Number of neurons for each dense layer. Allowed values: \code{1 <= x }}

\item{\code{dense_layers}}{\code{int} Number of dense layers. Allowed values: \code{0 <= x }}

\item{\code{rec_size}}{\code{int} Number of neurons for each recurrent layer. Allowed values: \code{1 <= x }}

\item{\code{rec_layers}}{\code{int} Number of recurrent layers. Allowed values: \code{0 <= x }}

\item{\code{rec_type}}{\code{string} Type of the recurrent layers. \code{rec_type='GRU'} for Gated Recurrent Unit and \code{rec_type='LSTM'} for Long Short-Term Memory. Allowed values: 'GRU', 'LSTM'}

\item{\code{rec_bidirectional}}{\code{bool} If \code{TRUE} a bidirectional version of the recurrent layers is used.}

\item{\code{embedding_dim}}{\code{int}  determining the number of dimensions for the embedding. Allowed values: \code{2 <= x }}

\item{\code{self_attention_heads}}{\code{int} determining the number of attention heads for a self-attention layer. Only relevant if \code{attention_type='multihead'} Allowed values: \code{0 <= x }}

\item{\code{intermediate_size}}{\code{int} determining the size of the projection layer within a each transformer encoder. Allowed values: \code{1 <= x }}

\item{\code{attention_type}}{\code{string} Choose the attention type. Allowed values: 'Fourier', 'MultiHead'}

\item{\code{add_pos_embedding}}{\code{bool} \code{TRUE} if positional embedding should be used.}

\item{\code{act_fct}}{\code{string} Activation function for all layers. Allowed values: 'ELU', 'LeakyReLU', 'ReLU', 'GELU', 'Sigmoid', 'Tanh', 'PReLU'}

\item{\code{parametrizations}}{\code{string} Re-Parametrizations of the weights of layers. Allowed values: 'None', 'OrthogonalWeights', 'WeightNorm', 'SpectralNorm'}

\item{\code{rec_dropout}}{\code{double} determining the dropout between recurrent layers. Allowed values: \verb{0 <= x <= 0.6}}

\item{\code{repeat_encoder}}{\code{int} determining how many times the encoder should be added to the network. Allowed values: \code{0 <= x }}

\item{\code{dense_dropout}}{\code{double} determining the dropout between dense layers. Allowed values: \verb{0 <= x <= 0.6}}

\item{\code{encoder_dropout}}{\code{double} determining the dropout for the dense projection within the transformer encoder layers. Allowed values: \verb{0 <= x <= 0.6}}

\item{\code{bias}}{\code{bool} If \code{TRUE} a bias term is added to all layers. If \code{FALSE} no bias term is added to the layers.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifierProtoNet-embed"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifierProtoNet-embed}{}}}
\subsection{Method \code{embed()}}{
Method for embedding documents. Please do not confuse this type of embeddings with the embeddings of
texts created by an object of class \link{TextEmbeddingModel}. These embeddings embed documents according to their
similarity to specific classes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifierProtoNet$embed(embeddings_q = NULL, batch_size = 32)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{embeddings_q}}{Object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings} containing the text
embeddings for all cases which should be embedded into the classification space.}

\item{\code{batch_size}}{\code{int} batch size.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a \code{list} containing the following elements
\itemize{
\item \code{embeddings_q}: embeddings for the cases (query sample).
\item \code{embeddings_prototypes}: embeddings of the prototypes which were learned during training. They represents the
center for the different classes.
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifierProtoNet-plot_embeddings"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifierProtoNet-plot_embeddings}{}}}
\subsection{Method \code{plot_embeddings()}}{
Method for creating a plot to visualize embeddings and their corresponding centers (prototypes).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifierProtoNet$plot_embeddings(
  embeddings_q,
  classes_q = NULL,
  batch_size = 12,
  alpha = 0.5,
  size_points = 3,
  size_points_prototypes = 8,
  inc_unlabeled = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{embeddings_q}}{Object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings} containing the text
embeddings for all cases which should be embedded into the classification space.}

\item{\code{classes_q}}{Named \code{factor} containg the true classes for every case. Please note that the names must match
the names/ids in \code{embeddings_q}.}

\item{\code{batch_size}}{\code{int} batch size.}

\item{\code{alpha}}{\code{float} Value indicating how transparent the points should be (important
if many points overlap). Does not apply to points representing prototypes.}

\item{\code{size_points}}{\code{int} Size of the points excluding the points for prototypes.}

\item{\code{size_points_prototypes}}{\code{int} Size of points representing prototypes.}

\item{\code{inc_unlabeled}}{\code{bool} If \code{TRUE} plot includes unlabeled cases as data points.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a plot of class \code{ggplot}visualizing embeddings.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifierProtoNet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifierProtoNet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifierProtoNet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
