% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_itt.R
\name{PlotDIMdecisions}
\alias{PlotDIMdecisions}
\title{Plot diff-in-means estimates}
\usage{
PlotDIMdecisions(
  res,
  y.max = 0.2,
  decision.labels = c("signature bond   ", "small cash bond   ", "large cash bond"),
  col.values = c("grey60", "grey30", "grey6"),
  shape.values = c(16, 17, 15)
)
}
\arguments{
\item{res}{A \code{data.frame} generated with \code{CalDIMsubgroup}.}

\item{y.max}{Maximum value of y-axis.}

\item{decision.labels}{Labels of decisions (D).}

\item{col.values}{Color of point for each decisions.}

\item{shape.values}{Shape of point for each decisions.}
}
\value{
A ggplot.
}
\description{
See Figure 2 for example.
}
\examples{
data(synth)
subgroup_synth = list(1:nrow(synth),which(synth$Sex==0),which(synth$Sex==1),
                      which(synth$Sex==1&synth$White==0),which(synth$Sex==1&synth$White==1))
res_dec = CalDIMsubgroup(synth, subgroup = subgroup_synth)
PlotDIMdecisions(res_dec, decision.labels = c("signature","small cash","middle cash","large cash"),
                 col.values = c("grey60", "grey30", "grey6", "grey1"), 
                 shape.values = c(16, 17, 15, 18))

}
