% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ability_human.R
\name{vis_diff_human}
\alias{vis_diff_human}
\title{Visualize Risk (Human+AI v. Human; internal)}
\usage{
vis_diff_human(
  df,
  label.subgroup1 = "Subgroup 1",
  label.subgroup2 = "Subgroup 2",
  x.order = NULL,
  p.title = NULL,
  p.lb = -0.2,
  p.ub = 0.2,
  y.lab = "Impact of PSA",
  p.label = c("PSA harms", "PSA helps")
)
}
\arguments{
\item{df}{A data frame generated by \code{compute_stats_aipw} and reshaped.}

\item{label.subgroup1}{A label for subgroup1 (character).}

\item{label.subgroup2}{A label for subgroup2 (character).}

\item{x.order}{An order for the x-axis (character vector). Default NULL.}

\item{p.title}{A title for the plot (character). Default NULL.}

\item{p.lb}{A lower bound for the y-axis (numeric). Default -0.2.}

\item{p.ub}{An upper bound for the y-axis (numeric). Default 0.2.}

\item{y.lab}{A label for the y-axis (character). Default "Impact of PSA".}

\item{p.label}{A vector of two labels for the annotations (character). Default c("PSA harms", "PSA helps").}
}
\value{
A ggplot object.
}
\description{
Internal function to visualize the difference in risk between human+AI and human decision makers.
}
\keyword{internal}
