% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_latest_imeca.R
\name{get_latest_imeca}
\alias{get_latest_imeca}
\title{Get the latest pollution values for each station}
\usage{
get_latest_imeca()
}
\value{
A data.frame with pollution values in IMECAs, the hour corresponds to
  the \emph{America/Mexico_City} timezone (which changes with daylight
  saving time)
}
\description{
Download the latest hourly values for the pollutants with the highest values
for each station as measured in
\href{https://en.wikipedia.org/wiki/Índice_Metropolitano_de_la_Calidad_del_Aire}{IMECAs}
}
\details{
Note that in 2015 it was determined that the stations with codes ACO, AJU,
INN, MON and MPA would no longer be taken into consideration when computing
the pollution index because they didn't meet the
\href{http://www.aire.cdmx.gob.mx/aire/objetivos-monitoreo-calidad-aire.html}{objectives
of monitoring air quality}, and are no longer included in the index, even if
they are still part of the SIMAT (Sistema de Monitoreo Atmosférico de la
Ciudad de México). Thus, even if they are located inside a zone, they are not
included in the pollution values for that zone.
}
\examples{
\donttest{
df <- get_latest_imeca()
head(df)
}
}
\seealso{
\href{http://www.aire.cdmx.gob.mx/aire/ultima-hora-reporte.php}{Reporte
  de calidad del aire}

Other IMECA functions: 
\code{\link{get_station_imeca}()},
\code{\link{get_zone_imeca}()}
}
\concept{IMECA functions}
