% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{prepare_for_plots_crm}
\alias{prepare_for_plots_crm}
\title{Utility function to make a dataframe from the continuous IRTmodel}
\usage{
prepare_for_plots_crm(mod, thetarange = c(-6, 6))
}
\arguments{
\item{mod}{IRT model, either from function \code{cirtmodel} or the \code{R} package \code{EstCRM}.}

\item{thetarange}{The range for \code{theta}, default from -6 to 6.}
}
\value{
Dataframe with output probabilities from the IRT model for all algorithms.
}
\description{
This is a utility function to make a dataframe from the continuous IRTmodel, which makes it easier to plot the surfaces
}
\examples{
data(classification_cts)
mod <- cirtmodel(classification_cts)
dat <- prepare_for_plots_crm(mod$model)
head(dat)

}
