% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w_spaces.R
\name{w_spaces}
\alias{w_spaces}
\title{Whitespaces removal}
\usage{
w_spaces(traj, remove="Both", verbose=TRUE)
}
\arguments{
\item{traj}{[matrix (numeric)]: longitudinal data. Each row
represents an individual trajectory (of observations).
The columns show the observations at consecutive time points.}

\item{remove}{[character]: Type of whitespace to remove.
That is, "Left" (leading), (2) "Right" (trailing), or "Both"
(both leading and trailing whitespaces). Default: "Both".}

\item{verbose}{to suppress output messages (to the console).
Default: \code{TRUE}.}
}
\value{
A matrix with all whitespaces (if any) removed.
}
\description{
This function removes all the leading and the
trailing whitespaces in data
}
\details{
Given a matrix suspected to contain whitespaces,
this function removes the type of the whitespaces specified and returns a
cleaned data. ’Whitespaces’ are white characters often
introduced into data during data entry, for instance by
wrongly pressing the spacebar. For example, neither " A"
nor "A " is the same as "A" because of the whitespaces that
exist in them. They can also result from systematic
errors in data recording devices.
}
\examples{

data(traj_w_spaces)

w_spaces(traj_w_spaces, remove="Both", verbose=TRUE)

}
\references{
\url{https://en.wikipedia.org/wiki/Whitespace_character}
}
