% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Diversity.R
\docType{class}
\name{DiversityTest-class}
\alias{DiversityTest}
\alias{DiversityTest-class}
\alias{print,DiversityTest-method}
\title{S4 class defining diversity significance}
\usage{
\S4method{print}{DiversityTest}(x)
}
\arguments{
\item{x}{DiversityTest object}
}
\description{
\code{DiversityTest} defines the signifance of diversity (\eqn{D}) differences at a 
fixed diversity order (\eqn{q}).
}
\section{Slots}{

\describe{
\item{\code{tests}}{data.frame describing the significance test results with columns:
\itemize{
  \item  \code{test}:          string listing the two groups tested.
  \item  \code{pvalue}:        p-value for the test.
  \item  \code{delta_mean}:    mean of the \eqn{D} bootstrap delta 
                               distribution for the test.
  \item  \code{delta_sd}:      standard deviation of the \eqn{D} 
                               bootstrap delta distribution for the test.
}}

\item{\code{summary}}{data.frame containing summary statistics for the diversity index 
bootstrap distributions, at the given value of \eqn{q}, with columns:
\itemize{
  \item  \code{group}:   the name of the group.
  \item  \code{mean}:    mean of the \eqn{D} bootstrap distribution.
  \item  \code{sd}:      standard deviation of the \eqn{D} bootstrap 
                         distribution.
}}

\item{\code{groups}}{character vector of groups retained in diversity calculation.}

\item{\code{q}}{diversity order tested (\eqn{q}).}

\item{\code{n}}{numeric vector indication the number of sequences sampled from each group.}

\item{\code{nboot}}{number of bootstrap realizations.}
}}

