% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aldvmm.sefit.R
\name{aldvmm.sefit}
\alias{aldvmm.sefit}
\title{Calculating Standard Errors of Fitted and Predicted Outcomes}
\usage{
aldvmm.sefit(
  par,
  yhat,
  X,
  type,
  formula,
  psi,
  cv,
  mse = NA,
  ncmp,
  dist,
  level,
  lcoef,
  lcmp,
  lcpar
)
}
\arguments{
\item{par}{a named numeric vector of parameter values.}

\item{yhat}{a numeric vector of predicted outcomes returned by
\ifelse{html}{\code{\link[aldvmm]{aldvmm.pred}}}{\code{aldvmm.pred()}}.}

\item{X}{a list of design matrices returned by
\ifelse{html}{\code{\link[aldvmm]{aldvmm.mm}}}{\code{aldvmm.mm()}}.
\code{'X'} is of length 2 and includes a design matrix for the model of
component distributions and a design matrix for the model of probabilities
of group membership.}

\item{type}{a character value of either 'fit' or 'pred' indicating whether
the standard error of the fit ('fit') or the standard error of predictions
in new data ('pred') are calculated.}

\item{formula}{an object of class \code{"formula"} with a symbolic
description of the model to be fitted. The model formula takes the form
\code{y ~ x1 + x2 | x1 + x4}, where the \code{|} delimiter separates the
model for expected values of normal distributions (left) and the
multinomial logit model of probabilities of component membership (right).}

\item{psi}{a numeric vector of minimum and maximum possible utility values
smaller than or equal to 1 (e.g. \code{c(-0.594, 0.883)}). The potential
gap between the maximum value and 1 represents an area with zero density
in the value set from which utilities were obtained. The order of the
minimum and maximum limits in \code{'psi'} does not matter.}

\item{cv}{a numeric matrix with covariances/variances of parameter estimates
returned by
\ifelse{html}{\code{\link[aldvmm]{aldvmm.cv}}}{\code{aldvmm.cv()}}.}

\item{mse}{a numeric value of the mean squared error of observed versus
predicted outcomes \eqn{\sum{(y - \hat{y})^2}/(n_{obs} - n_{par})}{\sum{(y
- \hat{y})^2}/(nobs - npar)} for all observations in model matrices
\code{'X'} supplied to
\ifelse{html}{\code{\link[aldvmm]{aldvmm.ll}}}{\code{aldvmm.ll()}}.}

\item{ncmp}{a numeric value of the number of components that are mixed. The
default value is 2. A value of 1 represents a tobit model with a gap
between 1 and the maximum value in \code{'psi'}.}

\item{dist}{an optional character value of the distribution used in the
finite mixture. In this release, only the normal distribution is
available, and the default value is set to \code{"normal"}.}

\item{level}{a numeric value of the significance level for confidence bands
of fitted values. The default value is 0.95.}

\item{lcoef}{a character vector of length 2 with labels of objects including
regression coefficients of component distributions (default \code{"beta"})
and coefficients of probabilities of component membership (default
\code{"delta"}).}

\item{lcmp}{a character value representing a stub (default \code{"Comp"})
for labeling objects including regression coefficients in different
components (e.g. "Comp1", "Comp2", ...). This label is also used in
summary tables returned by
\ifelse{html}{\code{\link[aldvmm]{summary.aldvmm}}}{\code{summary.aldvmm()}}.}

\item{lcpar}{a character vector with the labels of objects including
constant parameters of component distributions (e.g. the standard
deviation of the normal distribution). The length of \code{'lcpar'}
depends on the distribution supplied to \code{'dist'}.}
}
\value{
a named numeric vector of standard errors of fitted or predicted
  outcomes. The names of the elements in the vector are identical to the row
  names of design matrices in \code{'X'}
}
\description{
\ifelse{html}{\code{\link[aldvmm]{aldvmm.sefit}}}{\code{aldvmm.sefit()}}
calculates standard errors of fitted and predicted outcomes using the delta
method.
}
\details{
\ifelse{html}{\code{\link[aldvmm]{aldvmm.sefit}}}{\code{aldvmm.sefit()}}
calculates standard errors of fitted values using the delta method. Standard
errors of fitted values in the estimation data set are calculated as
\eqn{se_{fit} = \sqrt{G^{t} \Sigma G}}{se_fit = (t(grad)*\Sigma*grad)^0.5},
where \eqn{G} is the gradient of a fitted value with respect to changes of
parameter estimates, and \eqn{\Sigma} is the estimated covariance matrix of
parameters (Dowd et al., 2014).  Standard errors of predicted values in new
data sets are calculated as \eqn{se_{pred} = \sqrt{MSE + G^{t} \Sigma
G}}{se_pred = (mse + t(grad)*\Sigma*grad)^0.5}, where \eqn{MSE}{mse} is the
mean squared error of fitted versus observed outcomes in the original
estimation data (Whitmore, 1986).  The gradients of fitted values with
respect to parameter estimates are approximated numerically using
\ifelse{html}{\code{\link[numDeriv]{jacobian}}}{\code{numDeriv::jacobian()}}.
}
\references{
Whitmore, G. A. (1986). Prediction limits for a univariate
  normal observation. The American Statistician, 40(2), 141-143.
  https://doi.org/10.1080/00031305.1986.10475378 \cr

  Dowd, B. E., Greene, W. H., and Norton, E. C. (2014) Computation of
  standard errors. \emph{Health services research}, \bold{49(2)}, 731--750.
  \doi{10.1111/1475-6773.12122}
}
