% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aldvmm.tm.R
\name{aldvmm.tm}
\alias{aldvmm.tm}
\title{Creating Terms Objects}
\usage{
aldvmm.tm(mf, Formula, ncmp, lcoef)
}
\arguments{
\item{mf}{a data frame created by 
\ifelse{html}{\code{\link[stats]{model.frame}}}{\code{stats::model.frame}} 
including the variables used in \code{'formula'} supplied to 
\ifelse{html}{\code{\link[aldvmm]{aldvmm}}}{\code{aldvmm()}} plus 
additional attributes derived from \code{'formula'}.}

\item{Formula}{an object of class \code{'Formula'} created by 
\ifelse{html}{\code{\link[Formula]{Formula}}}{\code{Formula::Formula}} 
based on the \code{'formula'} supplied to 
\ifelse{html}{\code{\link[aldvmm]{aldvmm}}}{\code{aldvmm()}}.}

\item{ncmp}{a numeric value of the number of components that are mixed. The
default value is 2. A value of 1 represents a tobit model with a gap
between 1 and the maximum value in \code{'psi'}.}

\item{lcoef}{a character vector of length 2 with labels of objects including
regression coefficients of component distributions (default \code{"beta"})
and coefficients of probabilities of component membership (default
\code{"delta"}).}
}
\value{
a named list of objects of class \code{'terms'}. 
\item{\code{beta}}{a \code{'terms'} object for the model of component 
distributions.}
  \item{\code{delta}}{a \code{'terms'} object of the multinomial logit model
  of probabilities of component membership.}
  \item{\code{full}}{a \code{'terms'} object of the full model.}
}
\description{
\ifelse{html}{\code{\link[aldvmm]{aldvmm.tm}}}{\code{aldvmm.tm()}} creates
a list of up to three \code{'terms'} objects, one of the model of component distributions
(\code{"beta"}), one of the model of probabilities of component
membership (\code{"delta"}) and one for the full model (\code{"full"}).
}
\details{
\ifelse{html}{\code{\link[aldvmm]{aldvmm.tm}}}{\code{aldvmm.tm()}}
  uses
  \ifelse{html}{\code{\link[stats]{terms}}}{\code{stats::terms()}}
   to create \code{'terms'} objects based on a \code{'Formula'} object 
   created by 
   \ifelse{html}{\code{\link[Formula]{Formula}}}{\code{Formula::Formula}} 
   and a model frame created by 
   \ifelse{html}{\code{\link[stats]{model.frame}}}{\code{stats::model.frame}}. 
   The \code{'terms'} object for probabilities of group membership is only created if
  more than one components are specified in \code{'ncmp'}.
}
