% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ale_ixn.R
\name{plot_ale_ixn}
\alias{plot_ale_ixn}
\title{Plot ALE data}
\usage{
plot_ale_ixn(
  ale_data,
  x1_col,
  x2_col,
  y_col,
  y_type,
  y_summary,
  y_vals,
  relative_y = "median",
  plot_alpha = 0.05,
  n_x1_int = 20,
  n_x2_int = 20,
  n_y_quant = 10
)
}
\arguments{
\item{ale_data}{tibble. Output data from \code{calc_ale}.}

\item{x1_col, x2_col}{character length 1. Name of single x1 and single x2 column
whose ALE data is to be plotted. x1 is plotted on the x-axis while x2 is plotted
on the y axis.}

\item{y_col}{character length 1. Name of y (output) column whose ALE data is to
be plotted by colour.}

\item{y_type}{See documentation for \code{ale}}

\item{y_summary}{named double. Named vector of y summary statistics to be used
for plotting.}

\item{y_vals}{numeric. Vector of all values of y in the dataset used to create
\code{ale_data}.}

\item{relative_y}{See documentation for \code{ale}}

\item{plot_alpha}{See documentation for \code{ale}}

\item{n_x1_int, n_x2_int}{See documentation for \code{ale_ixn}}

\item{n_y_quant}{See documentation for \code{ale_ixn}}
}
\description{
This function is not exported. It creates a ggplot object that plots the input
ALE data generated from \code{calc_ale}.
This function is not usually called directly by the user. For details about
arguments not documented here, see \code{ale}.
}
