% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/baseline.R
\docType{methods}
\name{baseline_peakfilling}
\alias{baseline_peakfilling}
\alias{baseline_peakfilling-method}
\alias{baseline_peakfilling,numeric,numeric-method}
\alias{baseline_peakfilling,ANY,missing-method}
\title{4S Peak Filling}
\usage{
baseline_peakfilling(x, y, ...)

\S4method{baseline_peakfilling}{numeric,numeric}(x, y, n, m, by = 10)

\S4method{baseline_peakfilling}{ANY,missing}(x, n, m, by = 10)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Currently not used.}

\item{n}{An \code{\link{integer}} value giving the number of iterations.}

\item{m}{An odd \code{\link{integer}} giving the half window size.}

\item{by}{An \code{\link{integer}} specifying the binning ratio (i.e. the number of
points to be grouped together; see \code{\link[=window_tumbling]{window_tumbling()}}).}
}
\description{
Baseline estimation by iterative mean suppression.
}
\examples{
## gamma-ray spectrometry
data("BEGe")

## Subset from 2.75 to 200 keV
BEGe <- signal_select(BEGe, from = 3, to = 200)

## Plot spectrum
plot(BEGe, type = "l", xlab = "Energy (keV)", ylab = "Count")

## 4S Peak Filling
baseline <- baseline_peakfilling(BEGe, n = 5, m = 5, by = 2)

plot(BEGe, type = "l", xlab = "Energy (keV)", ylab = "Count")
lines(baseline, type = "l", col = "red")
}
\references{
Liland, K. H. (2015). 4S Peak Filling - baseline estimation by iterative
mean suppression. \emph{MethodsX}, 2, 135-140. \doi{10.1016/j.mex.2015.02.009}.
}
\seealso{
\code{\link[=signal_correct]{signal_correct()}}

Other baseline estimation methods: 
\code{\link{baseline_linear}()},
\code{\link{baseline_polynomial}()},
\code{\link{baseline_rollingball}()},
\code{\link{baseline_rubberband}()},
\code{\link{baseline_snip}()}
}
\author{
N. Frerebeau
}
\concept{baseline estimation methods}
