% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/resample.R
\docType{methods}
\name{resample_bin}
\alias{resample_bin}
\alias{resample_bin-method}
\alias{resample_bin,numeric,numeric-method}
\alias{resample_bin,ANY,missing-method}
\title{Bin}
\usage{
resample_bin(x, y, ...)

\S4method{resample_bin}{numeric,numeric}(x, y, by, f = mean, ...)

\S4method{resample_bin}{ANY,missing}(x, y, by, f = sum)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Extra parameters to be passed to \code{f}.}

\item{by}{An \code{\link{integer}} specifying the binning ratio (i.e. the number of
points to be grouped together; see \code{\link[=window_tumbling]{window_tumbling()}}).}

\item{f}{A \code{\link{function}} that takes a \code{numeric} vector of intensities as
argument and returns a single \code{numeric} vector. Used to estimate the local
representative value in each bin (defaults to \code{\link[=sum]{sum()}}; see examples).}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Averages \code{x} values and applies a function to the corresponding \code{y} values.
}
\examples{
## X-ray diffraction
data("XRD")

## Plot spectrum
plot(XRD, type = "l", xlab = expression(2*theta), ylab = "Count")

## Bin by 3
XRD_bin_mean <- resample_bin(XRD, by = 3, f = mean)
XRD_bin_min <- resample_bin(XRD, by = 3, f = min)

plot(XRD, type = "l", xlim = c(25, 35),
     xlab = expression(2*theta), ylab = "Count")
lines(XRD_bin_mean, type = "l", col = "red")
lines(XRD_bin_min, type = "l", col = "green")

## Downsample by 10
XRD_down <- resample_down(XRD, by = 10)

plot(XRD, type = "l", xlim = c(20, 40),
     xlab = expression(2*theta), ylab = "Count")
lines(XRD_down, type = "l", col = "red")

## Linearly interpolate
XRD_approx <- resample_interpolate(XRD, from = 20, to = 40, by = 0.02)

plot(XRD, type = "l", xlim = c(20, 40),
     xlab = expression(2*theta), ylab = "Count")
lines(XRD_approx, type = "l", col = "red")
}
\seealso{
Other resampling methods: 
\code{\link{resample_down}()},
\code{\link{resample_interpolate}()}
}
\author{
N. Frerebeau
}
\concept{resampling methods}
