% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_plot_aic2.R
\name{all_plot_aic2}
\alias{all_plot_aic2}
\title{Draws multiple scatter plots of all effect estimates against AIC}
\usage{
all_plot_aic2(data, xlab = "AIC", ylab = NULL, title = NULL)
}
\arguments{
\item{data}{\emph{Object} from \code{all_cox}, \code{all_glm}, \code{all_speedglm}, or \code{all_glm}, including all effect estimate values.}

\item{xlab}{\emph{Character} string for x-axis name. Default is \code{"AIC"}.}

\item{ylab}{\emph{Character} string for y-axis name. Default depends on original model types.}

\item{title}{\emph{Character} for plot title. Default is \code{"NULL"}.}
}
\value{
A  \pkg{ggplot2}  object: scatter plot.
}
\description{
\code{all_plot_aic2()} draws multiple scatter plots of
all effect estimates against AIC. Each plot indicates if a specific
variable is included in the models.
}
\examples{
\dontrun{
vlist <- c("Age", "Sex", "BMI", "Education", "Income")
results <- all_cox(crude = "Surv(t0, t1, Endpoint) ~ Diabetes", xlist = vlist, data = diab_df)
all_plot_aic(data = results)
}
}
