% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_tbl.R
\name{predict_allo}
\alias{predict_allo}
\title{Predict allometric attributes using a column of allometric models}
\usage{
predict_allo(model_list, ...)
}
\arguments{
\item{model_list}{A list-column of models}

\item{...}{Additional arguments passed to each model's \code{predict_fn}}
}
\value{
A vector of predictions
}
\description{
A frequent pattern in forest inventory anaylsis is the need to produce
predictions of models with the same functional form, but using different
models. \code{predict_allo} enables this by allowing the user to pass a
list-column of models as an argument, along with the associated covariates.
This pattern plays well with \code{dplyr} functions such as \code{dplyr::mutate()}.
}
\examples{
tree_data <- tibble::tibble(
 dbh = c(10, 20), ht = c(50, 75), model = c(list(brackett_rubra), list(brackett_acer))
)

tree_data \%>\%
  dplyr::mutate(vol = predict_allo(model, dbh, ht))
}
