% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbundle.R
\name{new_rbundle}
\alias{new_rbundle}
\alias{rbundle_restore}
\title{Constructor for an rbundle}
\usage{
new_rbundle(
  rschedules = list(),
  rdates = new_date(),
  exdates = new_date(),
  ...,
  class = character()
)

rbundle_restore(x, to)
}
\arguments{
\item{rschedules}{\verb{[list]}

A list of rschedules.}

\item{rdates}{\verb{[Date]}

A vector of dates to forcibly include in the event set.}

\item{exdates}{\verb{[Date]}

A vector of dates to forcibly exclude from the event set.}

\item{...}{\verb{[named dots]}

Additional named elements added to the rbundle object.}

\item{class}{\verb{[character]}

An optional subclass.}

\item{x}{\verb{[rbundle]}

An updated rbundle that needs to be restored to the type of \code{to}.}

\item{to}{\verb{[rbundle subclass]}

An rbundle subclass that you are restoring to.}
}
\value{
\itemize{
\item \code{new_rbundle()} returns a new rbundle.
\item \code{rbundle_restore()} should return an rbundle subclass of the same type
as \code{to}.
}
}
\description{
\code{new_rbundle()} is a developer focused tool that is not required for normal
usage of almanac. It constructs a new rbundle directly from a list of
existing rschedules.

\code{rbundle_restore()} is a generic function that rbundle subclasses can provide
a method for. It dispatches off of \code{to}. Its sole purpose is to restore
classes and fields of the subclass after calling any of the following
functions:
\itemize{
\item \code{add_rdates()}
\item \code{add_exdates()}
\item \code{add_rschedule()}
}
}
\details{
An rbundle is an abstract class that rintersect, runion, and rsetdiff all
inherit from. The sole purpose of an rbundle subclass is to implement an
\code{rbundle_restore()} method that defines how to recover the original
rbundle subclass after adding a new rschedule, rdate, or exdate.
Additionally, because rbundles are also rschedules, a \code{\link[=rschedule_events]{rschedule_events()}}
method must be implemented.
}
\examples{
new_rbundle()

x <- daily()
y <- weekly()

rschedules <- list(x, y)

new_rbundle(rschedules)
}
