% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recur-on-yday.R
\name{recur_on_yday}
\alias{recur_on_yday}
\title{Recur on a day of the year}
\usage{
recur_on_yday(x, yday)
}
\arguments{
\item{x}{\verb{[rrule]}

A recurrence rule.}

\item{yday}{\verb{[integer]}

Days of the year to recur on. Values must be from \verb{[-366, -1]} and
\verb{[1, 366]}.}
}
\value{
An updated rrule.
}
\description{
\code{recur_on_yday()} recurs on a specific day of the year.
}
\examples{
library(lubridate, warn.conflicts = FALSE)

on_5th_day_of_year <- yearly() \%>\% recur_on_yday(5)

alma_search("1999-01-01", "2000-12-31", on_5th_day_of_year)

# Notice that if you use a `since` date that has a day of the year
# after the specified one, it rolls to the next year
on_5th_day_of_year2 <- yearly(since = "1999-01-06") \%>\% recur_on_yday(5)
alma_search("1999-01-01", "2000-12-31", on_5th_day_of_year2)

# Negative values select from the back, which is useful in leap years
leap_year(as.Date("2000-01-01"))

last_day_of_year <- yearly() \%>\% recur_on_yday(-1)
last_day_of_year_bad <- yearly() \%>\% recur_on_yday(365)

alma_search("1999-01-01", "2000-12-31", last_day_of_year)
alma_search("1999-01-01", "2000-12-31", last_day_of_year_bad)

}
