## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(alphaN)

## -----------------------------------------------------------------------------
alpha <- alphaN(n = 1000, BF = 1)
alpha

## -----------------------------------------------------------------------------
JAB_plot(n = 1000, BF = 1)

## -----------------------------------------------------------------------------
seqN <- seq(50, 1000, 1)
plot(seqN, alphaN(seqN), type = "l",
     xlab = "n", ylab = "Alpha")

## -----------------------------------------------------------------------------
alphaN(1000, BF = 3, method = "balanced")

## -----------------------------------------------------------------------------
alphaN_plot(BF = 3)

## -----------------------------------------------------------------------------
df <-  read.csv("https://stats.idre.ucla.edu/stat/data/binary.csv")

## -----------------------------------------------------------------------------
str(df)

## -----------------------------------------------------------------------------
alpha_gre <- alphaN(n = 400, BF = 1, method = "JAB")
alpha_gre

## -----------------------------------------------------------------------------
glm1 <- glm(admit ~ gpa + factor(rank) + gre, data = df, family = "binomial")
summary(glm1)

## -----------------------------------------------------------------------------
JAB_gre <- JAB(glm1, covariate = "gre", method = "JAB")
JAB_gre

## -----------------------------------------------------------------------------
JABt(400, 2.070, method = "JAB")

## -----------------------------------------------------------------------------
JABp(400, 0.038465, z = TRUE, method = "JAB")

