% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_altair}
\alias{install_altair}
\title{Install Altair Python package}
\usage{
install_altair(
  method = c("conda", "virtualenv"),
  envname = "r-reticulate",
  pip = FALSE,
  version = getOption("altair.python.version"),
  ...
)
}
\arguments{
\item{method}{\code{character}, indicates to use \code{"conda"} or \code{"virtualenv"}}

\item{envname}{\code{character}, name of environment into which to install}

\item{pip, }{\code{logical}, used for conda installation to indicate to use pip
(will be set to TRUE for release-candidates)}

\item{version}{\code{character}, version of Altair to install. For general use of this package,
this is set automatically, so you should not need to specify this.}

\item{...}{other arguments sent to \code{\link[reticulate:conda-tools]{reticulate::conda_install()}} or
\code{\link[reticulate:virtualenv-tools]{reticulate::virtualenv_install()}}}
}
\value{
invisible \code{NULL}, called for side-effects
}
\description{
This function wraps installation functions from \link[reticulate:reticulate]{reticulate} to install the Python packages
\strong{altair} and \strong{vega_datasets}.
}
\details{
This package uses the \link[reticulate:reticulate]{reticulate} package
to make an interface with the \href{https://altair-viz.github.io/index.html}{Altair}
Python package. To promote consistency in usage of \strong{reticulate} among
different R packages, it is
\href{https://rstudio.github.io/reticulate/articles/package.html#installing-python-dependencies}{recommended}
to use a common Python environment, called \code{"r-reticulate"}.

Depending on your setup, you can create this environment using
\code{\link[reticulate:conda-tools]{reticulate::conda_create()}} or \code{\link[reticulate:virtualenv-tools]{reticulate::virtualenv_create()}},
as described in this
\href{https://rstudio.github.io/reticulate/articles/python_packages.html#conda-installation}{reticulate article},
or in this package's \href{https://vegawidget.github.io/altair/articles/installation.html#python-env}{Installation article}.
}
\examples{
\dontrun{
  # not run because it requires Python
  install_altair()
}
}
\seealso{
\href{https://vegawidget.github.io/altair/articles/installation.html}{altiar: Installation},
\href{https://rstudio.github.io/reticulate/articles/package.html}{reticulate: Using reticulate in an R Package},
\href{https://rstudio.github.io/reticulate/articles/python_packages.html}{reticulate: Installing Python Packages}
}
