% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download_geos}
\alias{download_geos}
\title{Download atmospheric composition data}
\usage{
download_geos(
  collection = c("aqc_tavg_1hr_g1440x721_v1", "chm_tavg_1hr_g1440x721_v1",
    "met_tavg_1hr_g1440x721_x1", "xgc_tavg_1hr_g1440x721_x1",
    "chm_inst_1hr_g1440x721_p23", "met_inst_1hr_g1440x721_p23"),
  date = c("2018-01-01", "2018-01-01"),
  directory_to_save = NULL,
  acknowledgement = FALSE,
  download = FALSE,
  remove_command = FALSE
)
}
\arguments{
\item{collection}{character(1). GEOS-CF data collection file name.}

\item{date}{character(2). length of 10 each. Start/end date for downloading data.
Format "YYYY-MM-DD" (ex. January 1, 2018 = \code{"2018-01-01"}).}

\item{directory_to_save}{character(1). Directory to save data.
Sub-directories will be created within \code{directory_to_save} for each
GEOS-CF collection.}

\item{acknowledgement}{logical(1). By setting \code{TRUE} the
user acknowledges that the data downloaded using this function may be very
large and use lots of machine storage and memory.}

\item{download}{logical(1). \code{FALSE} will generate a *.txt file
containing all download commands. By setting \code{TRUE} the function
will download all of the requested data files.}

\item{remove_command}{logical(1).
Remove (\code{TRUE}) or keep (\code{FALSE})
the text file containing download commands.}
}
\value{
NULL; netCDF (.nc4) files will be stored in a
collection-specific folder within \code{directory_to_save}.
}
\description{
The \code{download_geos()} function accesses and downloads various
atmospheric composition collections from \href{https://gmao.gsfc.nasa.gov/GEOS_systems/}{NASA's Global Earth Observing System (GEOS) model}.
}
\examples{
download_geos(
  collection = "aqc_tavg_1hr_g1440x721_v1",
  date = c("2024-01-01", "2024-01-01"),
  directory_to_save = tempdir(),
  acknowledgement = TRUE,
  download = FALSE, # NOTE: download skipped for examples,
  remove_command = TRUE
)
}
\references{
\insertRef{keller_description_2021}{amadeus}
}
\author{
Mitchell Manware, Insang Song
}
