% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariates.R
\name{calc_sedc}
\alias{calc_sedc}
\title{Calculate Sum of Exponentially Decaying Contributions (SEDC) covariates}
\usage{
calc_sedc(
  from = NULL,
  locs = NULL,
  locs_id = NULL,
  sedc_bandwidth = NULL,
  target_fields = NULL,
  geom = FALSE
)
}
\arguments{
\item{from}{\code{SpatVector} object. Locations where each SEDC is calculated.}

\item{locs}{\code{SpatVector} object. Locations where
the sum of SEDCs are calculated.}

\item{locs_id}{character(1). Name of the unique id field in \code{point_to}.}

\item{sedc_bandwidth}{numeric(1).
Distance at which the source concentration is reduced to
\code{exp(-3)} (approximately -95 \%)}

\item{target_fields}{character(varying). Field names in characters.}

\item{geom}{logical(1). Should the function return a \code{SpatVector}?
Default is \code{FALSE}. The coordinate reference system of the \code{SpatVector} is
that of \code{from.}}
}
\value{
a data.frame (tibble) or SpatVector object with input field names with
a suffix \code{"_sedc"} where the sums of EDC are stored.
Additional attributes are attached for the EDC information.
\itemize{
\item `attr(result, "sedc_bandwidth")``: the bandwidth where
concentration reduces to approximately five percent
\item `attr(result, "sedc_threshold")``: the threshold distance
at which emission source points are excluded beyond that
}
}
\description{
Calculate Sum of Exponentially Decaying Contributions (SEDC) covariates
}
\note{
The function is originally from
\href{https://github.com/NIEHS/chopin}{chopin}
Distance calculation is done with terra functions internally.
Thus, the function internally converts sf objects in
\code{point_*} arguments to terra.
The threshold should be carefully chosen by users.
}
\examples{
library(terra)
library(sf)
set.seed(101)
ncpath <- system.file("gpkg/nc.gpkg", package = "sf")
nc <- terra::vect(ncpath)
nc <- terra::project(nc, "EPSG:5070")
pnt_locs <- terra::centroids(nc, inside = TRUE)
pnt_locs <- pnt_locs[, "NAME"]
pnt_from <- terra::spatSample(nc, 10L)
pnt_from$pid <- seq(1, 10)
pnt_from <- pnt_from[, "pid"]
pnt_from$val1 <- rgamma(10L, 1, 0.05)
pnt_from$val2 <- rgamma(10L, 2, 1)

vals <- c("val1", "val2")
calc_sedc(pnt_locs, pnt_from, "NAME", 1e4, vals)
}
\references{
\insertRef{messier2012integrating}{amadeus}

\insertRef{web_sedctutorial_package}{amadeus}
}
\author{
Insang Song
}
