% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariates.R
\name{calculate_nei}
\alias{calculate_nei}
\title{Calculate road emissions covariates}
\usage{
calculate_nei(from = NULL, locs = NULL, locs_id = "site_id", geom = FALSE, ...)
}
\arguments{
\item{from}{SpatVector(1). Output of \code{process_nei()}.}

\item{locs}{sf/SpatVector. Locations at NEI values are joined.}

\item{locs_id}{character(1). Unique site identifier column name.
Unused but kept for compatibility.}

\item{geom}{FALSE/"sf"/"terra".. Should the function return with geometry?
Default is \code{FALSE}, options with geometry are "sf" or "terra". The
coordinate reference system of the \code{sf} or \code{SpatVector} is that of \code{from.}}

\item{...}{Placeholders.}
}
\value{
a data.frame or SpatVector object
}
\description{
Calculate road emissions covariates
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
loc <- data.frame(id = "001", lon = -78.90, lat = 35.97)
calculate_nei(
  from = nei, # derived from process_nei example
  locs = loc,
  locs_id = "id"
)
}
}
\seealso{
\code{\link{process_nei}}
}
\author{
Insang Song, Ranadeep Daw
}
