% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download_modis}
\alias{download_modis}
\title{Download MODIS product files}
\usage{
download_modis(
  product = c("MOD09GA", "MOD11A1", "MOD06_L2", "MCD19A2", "MOD13A2", "VNP46A2"),
  version = "61",
  horizontal_tiles = c(7, 13),
  vertical_tiles = c(3, 6),
  mod06_links = NULL,
  nasa_earth_data_token = NULL,
  date = c("2023-09-01", "2023-09-01"),
  directory_to_save = NULL,
  acknowledgement = FALSE,
  download = FALSE,
  remove_command = FALSE,
  hash = FALSE
)
}
\arguments{
\item{product}{character(1).
One of \code{c("MOD09GA", "MOD11A1", "MOD06_L2", "MCD19A2", "MOD13A2", "VNP46A2")}}

\item{version}{character(1). Default is \code{"61"}, meaning v061.}

\item{horizontal_tiles}{integer(2). Horizontal tile numbers
\code{c({start}, {end})}. Default is \code{c(7, 13)}.}

\item{vertical_tiles}{integer(2). Vertical tile numbers
\code{c({start}, {end})}. Default is \code{c(3, 6)}.}

\item{mod06_links}{character(1). CSV file path to MOD06_L2 download links
from \href{https://ladsweb.modaps.eosdis.nasa.gov/search/order/2/MOD06_L2--61}{NASA LAADS MOD06_L2}. Default is \code{NULL}.}

\item{nasa_earth_data_token}{character(1).
Token for downloading data from NASA. Should be set before
trying running the function.}

\item{date}{character(1 or 2). length of 10. Date or start/end dates for downloading data.
Format "YYYY-MM-DD" (ex. January 1, 2018 = \code{"2018-01-01"}). Note: ignored if
\code{product == "MOD06_L2"}.}

\item{directory_to_save}{character(1). Directory to save data.}

\item{acknowledgement}{logical(1). By setting \code{TRUE} the
user acknowledges that the data downloaded using this function may be very
large and use lots of machine storage and memory.}

\item{download}{logical(1). Download data or only save wget commands.}

\item{remove_command}{logical(1). Remove (\code{TRUE}) or keep (\code{FALSE})
the text file containing download commands.}

\item{hash}{logical(1). By setting \code{TRUE} the function will return
an \code{rlang::hash_file()} hash character corresponding to the
downloaded files. Default is \code{FALSE}.}
}
\value{
\itemize{
\item For \code{hash = FALSE}, NULL
\item For \code{hash = TRUE}, an \code{rlang::hash_file} character.
\item HDF (.hdf) files will be stored in year/day_of_year sub-directories within
\code{directory_to_save}.
}
}
\description{
Need maintenance for the directory path change
in NASA EOSDIS. This function first retrieves the all hdf download links
on a certain day, then only selects the relevant tiles from the retrieved
links. Download is only done at the queried horizontal-vertical tile number
combinations. An exception is MOD06_L2 product, which is produced
every five minutes every day.
}
\note{
Both dates in \code{date} should be in the same year.
Directory structure looks like
input/modis/raw/\{version\}/\{product\}/\{year\}/\{day_of_year\}.
}
\examples{
\dontrun{
## NOTE: Examples are wrapped in `/dontrun{}` to avoid sharing sensitive
##       NASA EarthData tokden information.
# example with MOD09GA product
download_modis(
  product = "MOD09GA",
  version = "61",
  horizontal_tiles = c(8, 8),
  vertical_tiles = c(4, 4),
  date = "2024-01-01",
  nasa_earth_data_token = "./pathtotoken/token.txt",
  directory_to_save = tempdir(),
  acknowledgement = TRUE,
  download = FALSE, # NOTE: download skipped for examples,
  remove_command = TRUE
)
# example with MOD06_L2 product
download_modis(
  product = "MOD06_L2",
  version = "61",
  horizontal_tiles = c(8, 8),
  vertical_tiles = c(4, 4),
  date = "2024-01-01",
  mod06_links =
    system.file(
      "extdata", "nasa", "LAADS_query.2024-08-02T12_49.csv",
      package = "amadeus"
    ),
  nasa_earth_data_token = "./pathtotoken/token.txt",
  directory_to_save = tempdir(),
  acknowledgement = TRUE,
  download = FALSE, # NOTE: download skipped for examples,
  remove_command = TRUE
)
# example with VNP46A2 product
download_modis(
  product = "VNP46A2",
  version = "61",
  horizontal_tiles = c(8, 8),
  vertical_tiles = c(4, 4),
  date = "2024-01-01",
  nasa_earth_data_token = "./pathtotoken/token.txt",
  directory_to_save = tempdir(),
  acknowledgement = TRUE,
  download = FALSE, # NOTE: download skipped for examples,
  remove_command = TRUE
)
}
}
\references{
\insertRef{data_mcd19a22021}{amadeus}

\insertRef{data_mod06l2_2017}{amadeus}

\insertRef{data_mod09ga2021}{amadeus}

\insertRef{data_mod11a12021}{amadeus}

\insertRef{data_mod13a22021}{amadeus}

\insertRef{article_roman2018vnp46}{amadeus}
}
\author{
Mitchell Manware, Insang Song
}
