% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{volcano_plot}
\alias{volcano_plot}
\title{Volcano plot of combined results}
\usage{
volcano_plot(mets, cutoff = NULL)
}
\arguments{
\item{mets}{an S4 METAtables object}

\item{cutoff}{values for p-value and fold-change significance}
}
\value{
plot of results
}
\description{
\code{volcano_plot} returns a volcano plot of the combined results on each metabolite obtained by \code{compute_amanida} function
}
\details{
Results are presented as -log10 for p-value and log2 for fold-change.
Values over the cut off are labeled. If not cutoff is provided will be used alpha 0.05 for p-value and 1.5 for logarithmic fold-change.
}
\examples{
\dontrun{
   data("sample_data")
   
   amanida_result <- compute_amanida(sample_data)
   volcano_plot(amanida_result)
}

}
