% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intFun.R
\name{intFun.sampleGridTimeAndSpace}
\alias{intFun.sampleGridTimeAndSpace}
\title{random sampling across space and time (if available) for reference grid data}
\usage{
intFun.sampleGridTimeAndSpace(ref)
}
\arguments{
\item{ref}{A raster object}
}
\value{
A raster object
}
\description{
This function conducts random sampling with replacement for a single raster layer
}
\examples{

library(raster)
# make some data
data01 <- c(seq(1,99,1), NA)
data02 <- c(NA, seq(101,199,1))
data03 <- data01 + data02
data01 <- raster::raster(matrix(data01, ncol=10))
data02 <- raster::raster(matrix(data02, ncol=10))
data03 <- raster::raster(matrix(data03, ncol=10))
data <- raster::stack(data01, data02, data03)

randomSample <- intFun.sampleGridTimeAndSpace(ref = data)
plot(data)
plot(randomSample)

}
\keyword{internal}
