% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.compare.R
\name{metrics.compare}
\alias{metrics.compare}
\title{Compares global mean statistical meterics for multiple model runs}
\usage{
metrics.compare(mod.path.list = mod.path.list, plot.width = 13,
  plot.height = 14, outputDir = FALSE, defineVariableOrder = TRUE,
  myVariables = myVariables)
}
\arguments{
\item{mod.path.list}{A list with paths for each model run, e.g. mod.path.list <- list(mod01.path, mod02.path, mod03.path)}

\item{plot.width}{Number that gives the plot width, e.g. 6}

\item{plot.height}{Number that gives the plot height, e.g. 5}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory.}

\item{defineVariableOrder}{Logical. If TRUE, variables are sorted according to the parameter myVariables defined below. Default setting is FALSE.}

\item{myVariables}{An R object with variable names of variables that should be included in table, e.g. c('GPP', 'RECO', 'NEE')}
}
\value{
A figure in PDF format that shows statistical metrics for multiple model runs.
}
\description{
This function plots statistical meterics for multiple model runs.
This is useful for comparing the impact of changes in model settings or input data.
}
\examples{

library(amber)
library(classInt)
library(doParallel)
library(foreach)
library(Hmisc)
library(latex2exp)
library(ncdf4)
library(parallel)
library(raster)
library(rgdal)
library(rgeos)
library(scico)
library(sp)
library(stats)
library(utils)
library(viridis)
library(xtable)

mod01.path <- system.file('extdata/SIMod01', package = 'amber')
mod02.path <- system.file('extdata/SIMod02', package = 'amber')

mod.path.list <- list(mod01.path, mod02.path)
myVariables <- c('RNS', 'RSS', 'RLS', 'ALBS', 'HFLS', 'HFSS', 'HFG', 'GPP',
'RECO', 'NEE', 'FIRE', 'AGB', 'CVEG', 'CSOIL', 'LAI', 'BURNT', 'SNW', 'MRSLL', 'MRRO')

myVariables <- c('ALBS', 'GPP', 'LAI')

metrics.compare(mod.path.list = mod.path.list, plot.width = 5, plot.height = 15,
outputDir = FALSE, defineVariableOrder = TRUE, myVariables = myVariables)

}
