% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ambiorix.R
\name{Ambiorix}
\alias{Ambiorix}
\title{Ambiorix}
\value{
An object of class \code{Ambiorix} from which one can
add routes, routers, and run the application.
}
\description{
Web server.
}
\examples{
app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

app$on_stop <- function(){
 cat("Bye!\n")
}

if(interactive())
 app$start()


## ------------------------------------------------
## Method `Ambiorix$listen`
## ------------------------------------------------

app <- Ambiorix$new()

app$listen(3000L)

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()

## ------------------------------------------------
## Method `Ambiorix$get`
## ------------------------------------------------

app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()

## ------------------------------------------------
## Method `Ambiorix$set_404`
## ------------------------------------------------

app <- Ambiorix$new()

app$set_404(function(req, res){
 res$send("Nothing found here")
})

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()

## ------------------------------------------------
## Method `Ambiorix$start`
## ------------------------------------------------

app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()

## ------------------------------------------------
## Method `Ambiorix$receive`
## ------------------------------------------------

app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

app$receive("hello", function(msg, ws){
 print(msg) # print msg received
 
 # send a message back
 ws$send("hello", "Hello back! (sent from R)")
})

if(interactive())
 app$start()

## ------------------------------------------------
## Method `Ambiorix$serialiser`
## ------------------------------------------------

app <- Ambiorix$new()

app$serialiser(function(data, ...){
 jsonlite::toJSON(x, ..., pretty = TRUE)
})

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{not_found}}{404 Response, must be a handler function that accepts the request and the response, by default uses \code{\link[=response_404]{response_404()}}.}

\item{\code{is_running}}{Boolean indicating whether the server is running.}

\item{\code{error}}{500 response when the route errors, must a handler function that accepts the request and the response, by default uses \code{\link[=response_500]{response_500()}}.}

\item{\code{on_stop}}{Callback function to run when the app stops, takes no argument.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{websocket}}{A handler function that accepts a websocket which overrides ambiorix internal websocket handling.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Ambiorix$new()}}
\item \href{#method-listen}{\code{Ambiorix$listen()}}
\item \href{#method-get}{\code{Ambiorix$get()}}
\item \href{#method-put}{\code{Ambiorix$put()}}
\item \href{#method-patch}{\code{Ambiorix$patch()}}
\item \href{#method-delete}{\code{Ambiorix$delete()}}
\item \href{#method-post}{\code{Ambiorix$post()}}
\item \href{#method-options}{\code{Ambiorix$options()}}
\item \href{#method-all}{\code{Ambiorix$all()}}
\item \href{#method-set_404}{\code{Ambiorix$set_404()}}
\item \href{#method-static}{\code{Ambiorix$static()}}
\item \href{#method-start}{\code{Ambiorix$start()}}
\item \href{#method-receive}{\code{Ambiorix$receive()}}
\item \href{#method-serialiser}{\code{Ambiorix$serialiser()}}
\item \href{#method-stop}{\code{Ambiorix$stop()}}
\item \href{#method-print}{\code{Ambiorix$print()}}
\item \href{#method-use}{\code{Ambiorix$use()}}
\item \href{#method-clone}{\code{Ambiorix$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$new(
  host = getOption("ambiorix.host", "0.0.0.0"),
  port = getOption("ambiorix.port", NULL),
  log = getOption("ambiorix.logger", TRUE)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host}}{A string defining the host.}

\item{\code{port}}{Integer defining the port, defaults to \code{ambiorix.port} option: uses a random port if \code{NULL}.}

\item{\code{log}}{Whether to generate a log of events.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Define the webserver.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-listen"></a>}}
\if{latex}{\out{\hypertarget{method-listen}{}}}
\subsection{Method \code{listen()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$listen(port)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{port}}{Port number.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Specifies the port to listen on.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{app <- Ambiorix$new()

app$listen(3000L)

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get"></a>}}
\if{latex}{\out{\hypertarget{method-get}{}}}
\subsection{Method \code{get()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$get(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to, \code{:} defines a parameter.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
GET Method

Add routes to listen to.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-put"></a>}}
\if{latex}{\out{\hypertarget{method-put}{}}}
\subsection{Method \code{put()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$put(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to, \code{:} defines a parameter.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
PUT Method

Add routes to listen to.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-patch"></a>}}
\if{latex}{\out{\hypertarget{method-patch}{}}}
\subsection{Method \code{patch()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$patch(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to, \code{:} defines a parameter.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
PATCH Method

Add routes to listen to.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$delete(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to, \code{:} defines a parameter.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
DELETE Method

Add routes to listen to.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-post"></a>}}
\if{latex}{\out{\hypertarget{method-post}{}}}
\subsection{Method \code{post()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$post(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
POST Method

Add routes to listen to.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-options"></a>}}
\if{latex}{\out{\hypertarget{method-options}{}}}
\subsection{Method \code{options()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$options(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
OPTIONS Method

Add routes to listen to.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-all"></a>}}
\if{latex}{\out{\hypertarget{method-all}{}}}
\subsection{Method \code{all()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$all(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
All Methods

Add routes to listen to for all methods \code{GET}, \code{POST}, \code{PUT}, \code{DELETE}, and \code{PATCH}.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_404"></a>}}
\if{latex}{\out{\hypertarget{method-set_404}{}}}
\subsection{Method \code{set_404()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$set_404(handler)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Sets the 404 page.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{app <- Ambiorix$new()

app$set_404(function(req, res){
 res$send("Nothing found here")
})

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-static"></a>}}
\if{latex}{\out{\hypertarget{method-static}{}}}
\subsection{Method \code{static()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$static(path, uri = "www")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Local path to directory of assets.}

\item{\code{uri}}{URL path where the directory will be available.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Static directories
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-start"></a>}}
\if{latex}{\out{\hypertarget{method-start}{}}}
\subsection{Method \code{start()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$start(auto_stop = TRUE, open = interactive())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{auto_stop}}{Whether to automatically stop the server when the functon exits.}

\item{\code{open}}{Whether to open the app the browser.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Start
Start the webserver.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-receive"></a>}}
\if{latex}{\out{\hypertarget{method-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$receive(name, handler)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of message.}

\item{\code{handler}}{Function to run when message is received.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Receive Websocket Message
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

app$receive("hello", function(msg, ws){
 print(msg) # print msg received
 
 # send a message back
 ws$send("hello", "Hello back! (sent from R)")
})

if(interactive())
 app$start()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-serialiser"></a>}}
\if{latex}{\out{\hypertarget{method-serialiser}{}}}
\subsection{Method \code{serialiser()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$serialiser(handler)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{handler}}{Function to use to serialise.
This function should accept two arguments: the object to serialise and \code{...}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Define Serialiser
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{app <- Ambiorix$new()

app$serialiser(function(data, ...){
 jsonlite::toJSON(x, ..., pretty = TRUE)
})

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-stop"></a>}}
\if{latex}{\out{\hypertarget{method-stop}{}}}
\subsection{Method \code{stop()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$stop()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Stop
Stop the webserver.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Print
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-use"></a>}}
\if{latex}{\out{\hypertarget{method-use}{}}}
\subsection{Method \code{use()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$use(use)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use}}{Either a router as returned by \link{Router}, a function to use as middleware,
or a \code{list} of functions.
If a function is passed, it must accept two arguments (the request, and the response):
this function will be executed every time the server receives a request.
\emph{Middleware may but does not have to return a response, unlike other methods such as \code{get}}
Note that multiple routers and middlewares can be used.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Use a router or middleware
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
