% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.R
\name{using_ci}
\alias{using_ci}
\alias{using_appveyor}
\alias{using_circle_ci}
\alias{using_codebuild}
\alias{using_github_actions}
\alias{using_gitlab_ci}
\alias{using_jenkins}
\alias{using_travis_ci}
\title{Detect whether running in a CI environment}
\usage{
using_ci(service = NULL)

using_appveyor()

using_circle_ci()

using_codebuild()

using_github_actions()

using_gitlab_ci()

using_jenkins()

using_travis_ci()
}
\arguments{
\item{service}{If provided, a particular CI service is checked. If not, the
commonly-used \code{CI} environment variable is checked.}
}
\value{
A logical value
}
\description{
\code{using_ci()} reports whether a continuous integration
environment is being used.

\code{using_appveyor()} reports whether AppVeyor is being used

\code{using_circle_ci()} reports whether CircleCI is being used

\code{using_codebuild()} reports whether AWS CodeBuild is being used

\code{using_github_actions()} reports whether GitHub Actions is being
used

\code{using_gitlab_ci()} reports whether GitLab CI/CD is being used

\code{using_jenkins()} reports whether Jenkins is being used

\code{using_travis_ci()} reports whether Travis CI is being used
}
\examples{
using_ci()
using_appveyor()
using_circle_ci()
using_codebuild()
using_github_actions()
using_gitlab_ci()
using_jenkins()
using_travis_ci()
}
