# amExample1 from pg 5 in allelematchSuppDoc.pdf is 2.5.3 compatible

    Code
      example1 <- amDataset(amExample1, indexColumn = "sampleId", ignoreColumn = "knownIndividual", missingCode = "-99")

---

    structure(list(index = c("1", "2", "3", "4", "5", "6", "7", "8", 
    "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
    "20"), multilocus = structure(c("103", "103", "104", "104", "103", 
    "103", "108", "104", "109", "109", "108", "108", "109", "108", 
    "108", "108", "103", "103", "108", "108", "108", "108", "120", 
    "120", "109", "109", "109", "110", "120", "120", "109", "109", 
    "110", "120", "120", "109", "109", "109", "114", "114", "201", 
    "201", "201", "201", "201", "201", "201", "207", "208", "208", 
    "201", "201", "203", "208", "208", "203", "208", "208", "201", 
    "201", "201", "201", "208", "208", "209", "209", "208", "208", 
    "208", "208", "208", "208", "207", "209", "209", "203", "208", 
    "208", "207", "207", "314", "314", "306", "306", "306", "306", 
    "314", "307", "307", "307", "306", "306", "313", "307", "307", 
    "317", "306", "306", "-99", "306", "318", "318", "314", "314", 
    "306", "306", "314", "317", "307", "307", "317", "317", "317", 
    "313", "313", "318", "307", "307", "-99", "317", "405", "405", 
    "407", "407", "408", "408", "404", "417", "407", "407", "404", 
    "404", "407", "417", "417", "407", "404", "404", "404", "404", 
    "417", "417", "407", "407", "414", "414", "417", "417", "417", 
    "417", "413", "413", "417", "417", "417", "417", "413", "413", 
    "413", "413", "514", "514", "502", "502", "501", "501", "501", 
    "516", "505", "505", "502", "502", "505", "502", "502", "505", 
    "502", "502", "502", "502", "519", "519", "502", "502", "502", 
    "502", "514", "516", "519", "519", "514", "514", "519", "516", 
    "516", "519", "519", "519", "519", "519", "603", "603", "607", 
    "607", "603", "603", "607", "603", "607", "607", "603", "603", 
    "607", "602", "602", "607", "602", "602", "603", "603", "618", 
    "618", "616", "616", "607", "607", "618", "603", "618", "618", 
    "607", "607", "618", "618", "618", "616", "603", "603", "607", 
    "607", "709", "709", "713", "713", "706", "706", "706", "717", 
    "703", "703", "703", "703", "706", "703", "703", "712", "709", 
    "709", "712", "712", "715", "715", "715", "715", "706", "706", 
    "715", "719", "709", "709", "719", "719", "719", "715", "715", 
    "715", "717", "717", "715", "715", "804", "804", "804", "804", 
    "804", "804", "804", "804", "804", "804", "812", "812", "811", 
    "811", "811", "804", "816", "816", "804", "804", "816", "816", 
    "816", "816", "804", "804", "811", "812", "805", "805", "816", 
    "816", "811", "816", "816", "812", "816", "816", "811", "811", 
    "911", "911", "912", "912", "914", "914", "914", "907", "914", 
    "914", "911", "911", "914", "911", "911", "914", "911", "911", 
    "911", "911", "914", "914", "914", "914", "918", "918", "914", 
    "914", "914", "914", "911", "911", "915", "914", "914", "915", 
    "914", "914", "911", "911", "1007", "1007", "1006", "1006", "1006", 
    "1006", "1006", "1007", "1007", "1007", "1015", "1015", "1018", 
    "1007", "1007", "1015", "1005", "1005", "1015", "1015", "1015", 
    "1015", "1015", "1015", "1006", "1006", "1015", "1019", "1015", 
    "1015", "1015", "1015", "1018", "1015", "1015", "1015", "1007", 
    "1007", "1018", "1018"), dim = c(20L, 20L), dimnames = list(NULL, 
        c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", 
        "LOC4b", "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", 
        "LOC8a", "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), 
        missingCode = "-99"), class = "amDataset")

---

    Code
      uniqueExample1 <- amUnique(example1, alleleMismatch = 2, verbose = FALSE)
    Output
      allelematch:  assuming genotype columns are in pairs, representing 10 loci

---

    structure(list(pairwise = list(list(focal = list(index = "1", 
        metaData = NULL, multilocus = structure(c("103", "108", "201", 
        "201", "314", "318", "405", "417", "514", "519", "603", "618", 
        "709", "715", "804", "816", "911", "914", "1007", "1015"), dim = c(1L, 
        20L), dimnames = list(NULL, c("LOC1a", "LOC1b", "LOC2a", 
        "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", 
        "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", "LOC8b", "LOC9a", 
        "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(1L, 
        20L)), rowFlag = "UNIQUE"), match = list(index = c("1", "2"
    ), multilocus = structure(c("103", "103", "108", "108", "201", 
    "201", "201", "201", "314", "314", "318", "318", "405", "405", 
    "417", "417", "514", "514", "519", "519", "603", "603", "618", 
    "618", "709", "709", "715", "715", "804", "804", "816", "816", 
    "911", "911", "914", "914", "1007", "1007", "1015", "1015"), dim = c(2L, 
    20L), dimnames = list(NULL, c("LOC1a", "LOC1b", "LOC2a", "LOC2b", 
    "LOC3a", "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", "LOC6a", 
    "LOC6b", "LOC7a", "LOC7b", "LOC8a", "LOC8b", "LOC9a", "LOC9b", 
    "LOC10a", "LOC10b"))), score = c("1", "1"), flags = structure(c(1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(2L, 
    20L)), perfect = 2L, partial = 0L, psib = c(9.84097837711721e-05, 
    9.84097837711721e-05), rowFlag = c("", ""), psibNotCalculable = 0L)), 
        list(focal = list(index = "3", metaData = NULL, multilocus = structure(c("104", 
        "120", "201", "208", "306", "314", "407", "407", "502", "502", 
        "607", "616", "713", "715", "804", "816", "912", "914", "1006", 
        "1015"), dim = c(1L, 20L), dimnames = list(NULL, c("LOC1a", 
        "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", 
        "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
        "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(1L, 
        20L)), rowFlag = "UNIQUE"), match = list(index = c("3", "4"
        ), multilocus = structure(c("104", "104", "120", "120", "201", 
        "201", "208", "208", "306", "306", "314", "314", "407", "407", 
        "407", "407", "502", "502", "502", "502", "607", "607", "616", 
        "616", "713", "713", "715", "715", "804", "804", "816", "816", 
        "912", "912", "914", "914", "1006", "1006", "1015", "1015"
        ), dim = c(2L, 20L), dimnames = list(NULL, c("LOC1a", "LOC1b", 
        "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", "LOC5a", 
        "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", "LOC8b", 
        "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), score = c("1", "1"
        ), flags = structure(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(2L, 20L)), perfect = 2L, 
            partial = 0L, psib = c(7.6700235101921e-05, 7.6700235101921e-05
            ), rowFlag = c("", ""), psibNotCalculable = 0L)), list(
            focal = list(index = "5", metaData = NULL, multilocus = structure(c("103", 
            "109", "201", "209", "306", "306", "408", "414", "501", 
            "502", "603", "607", "706", "706", "804", "804", "914", 
            "918", "1006", "1006"), dim = c(1L, 20L), dimnames = list(
                NULL, c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", 
                "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", "LOC6a", 
                "LOC6b", "LOC7a", "LOC7b", "LOC8a", "LOC8b", "LOC9a", 
                "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1), dim = c(1L, 20L)), rowFlag = "UNIQUE"), match = list(
                index = c("5", "6"), multilocus = structure(c("103", 
                "103", "109", "109", "201", "201", "209", "209", 
                "306", "306", "306", "306", "408", "408", "414", 
                "414", "501", "501", "502", "502", "603", "603", 
                "607", "607", "706", "706", "706", "706", "804", 
                "804", "804", "804", "914", "914", "918", "918", 
                "1006", "1006", "1006", "1006"), dim = c(2L, 20L), dimnames = list(
                    NULL, c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", 
                    "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", 
                    "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
                    "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"
                    ))), score = c("1", "1"), flags = structure(c(1, 
                1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                1, 1, 1, 1, 1), dim = c(2L, 20L)), perfect = 2L, 
                partial = 0L, psib = c(4.755381397187e-05, 4.755381397187e-05
                ), rowFlag = c("", ""), psibNotCalculable = 0L)), 
        list(focal = list(index = "7", metaData = NULL, multilocus = structure(c("108", 
        "109", "201", "208", "314", "314", "404", "417", "501", "514", 
        "607", "618", "706", "715", "804", "811", "914", "914", "1006", 
        "1015"), dim = c(1L, 20L), dimnames = list(NULL, c("LOC1a", 
        "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", 
        "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
        "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(1L, 
        20L)), rowFlag = "UNIQUE"), match = list(index = "7", multilocus = structure(c("108", 
        "109", "201", "208", "314", "314", "404", "417", "501", "514", 
        "607", "618", "706", "715", "804", "811", "914", "914", "1006", 
        "1015"), dim = c(1L, 20L), dimnames = list(NULL, c("LOC1a", 
        "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", 
        "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
        "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), score = "1", 
            flags = structure(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(1L, 20L)), perfect = 1L, 
            partial = 0L, psib = 0.000147527555438071, rowFlag = "", 
            psibNotCalculable = 0L)), list(focal = list(index = "8", 
            metaData = NULL, multilocus = structure(c("104", "110", 
            "207", "208", "307", "317", "417", "417", "516", "516", 
            "603", "603", "717", "719", "804", "812", "907", "914", 
            "1007", "1019"), dim = c(1L, 20L), dimnames = list(NULL, 
                c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", 
                "LOC4a", "LOC4b", "LOC5a", "LOC5b", "LOC6a", "LOC6b", 
                "LOC7a", "LOC7b", "LOC8a", "LOC8b", "LOC9a", "LOC9b", 
                "LOC10a", "LOC10b"))), flags = structure(c(1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(1L, 
            20L)), rowFlag = "UNIQUE"), match = list(index = "8", 
            multilocus = structure(c("104", "110", "207", "208", 
            "307", "317", "417", "417", "516", "516", "603", "603", 
            "717", "719", "804", "812", "907", "914", "1007", "1019"
            ), dim = c(1L, 20L), dimnames = list(NULL, c("LOC1a", 
            "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", 
            "LOC4b", "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", 
            "LOC7b", "LOC8a", "LOC8b", "LOC9a", "LOC9b", "LOC10a", 
            "LOC10b"))), score = "1", flags = structure(c(1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(1L, 
            20L)), perfect = 1L, partial = 0L, psib = 4.20062196368826e-05, 
            rowFlag = "", psibNotCalculable = 0L)), list(focal = list(
            index = "9", metaData = NULL, multilocus = structure(c("109", 
            "120", "208", "208", "307", "307", "407", "417", "505", 
            "519", "607", "618", "703", "709", "804", "805", "914", 
            "914", "1007", "1015"), dim = c(1L, 20L), dimnames = list(
                NULL, c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", 
                "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", "LOC6a", 
                "LOC6b", "LOC7a", "LOC7b", "LOC8a", "LOC8b", "LOC9a", 
                "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1), dim = c(1L, 20L)), rowFlag = "UNIQUE"), match = list(
            index = c("9", "10"), multilocus = structure(c("109", 
            "109", "120", "120", "208", "208", "208", "208", "307", 
            "307", "307", "307", "407", "407", "417", "417", "505", 
            "505", "519", "519", "607", "607", "618", "618", "703", 
            "703", "709", "709", "804", "804", "805", "805", "914", 
            "914", "914", "914", "1007", "1007", "1015", "1015"), dim = c(2L, 
            20L), dimnames = list(NULL, c("LOC1a", "LOC1b", "LOC2a", 
            "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", "LOC5a", 
            "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
            "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), score = c("1", 
            "1"), flags = structure(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(2L, 20L
            )), perfect = 2L, partial = 0L, psib = c(0.000127630848132018, 
            0.000127630848132018), rowFlag = c("", ""), psibNotCalculable = 0L)), 
        list(focal = list(index = "11", metaData = NULL, multilocus = structure(c("108", 
        "109", "201", "208", "306", "317", "404", "413", "502", "514", 
        "603", "607", "703", "719", "812", "816", "911", "911", "1015", 
        "1015"), dim = c(1L, 20L), dimnames = list(NULL, c("LOC1a", 
        "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", 
        "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
        "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(1L, 
        20L)), rowFlag = "UNIQUE"), match = list(index = c("11", 
        "12"), multilocus = structure(c("108", "108", "109", "109", 
        "201", "201", "208", "208", "306", "306", "317", "317", "404", 
        "404", "413", "413", "502", "502", "514", "514", "603", "603", 
        "607", "607", "703", "703", "719", "719", "812", "812", "816", 
        "816", "911", "911", "911", "911", "1015", "1015", "1015", 
        "1015"), dim = c(2L, 20L), dimnames = list(NULL, c("LOC1a", 
        "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", 
        "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
        "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), score = c("1", 
        "1"), flags = structure(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(2L, 20L)), perfect = 2L, 
            partial = 0L, psib = c(0.000100870314036143, 0.000100870314036143
            ), rowFlag = c("", ""), psibNotCalculable = 0L)), list(
            focal = list(index = "13", metaData = NULL, multilocus = structure(c("109", 
            "110", "203", "207", "313", "317", "407", "417", "505", 
            "519", "607", "618", "706", "719", "811", "811", "914", 
            "915", "1018", "1018"), dim = c(1L, 20L), dimnames = list(
                NULL, c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", 
                "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", "LOC6a", 
                "LOC6b", "LOC7a", "LOC7b", "LOC8a", "LOC8b", "LOC9a", 
                "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1), dim = c(1L, 20L)), rowFlag = "UNIQUE"), match = list(
                index = "13", multilocus = structure(c("109", "110", 
                "203", "207", "313", "317", "407", "417", "505", 
                "519", "607", "618", "706", "719", "811", "811", 
                "914", "915", "1018", "1018"), dim = c(1L, 20L), dimnames = list(
                    NULL, c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", 
                    "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", 
                    "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
                    "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"
                    ))), score = "1", flags = structure(c(1, 1, 1, 
                1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
                ), dim = c(1L, 20L)), perfect = 1L, partial = 0L, 
                psib = 3.91984649146532e-05, rowFlag = "", psibNotCalculable = 0L)), 
        list(focal = list(index = "14", metaData = NULL, multilocus = structure(c("108", 
        "120", "208", "209", "307", "313", "417", "417", "502", "516", 
        "602", "618", "703", "715", "811", "816", "911", "914", "1007", 
        "1015"), dim = c(1L, 20L), dimnames = list(NULL, c("LOC1a", 
        "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", 
        "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
        "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(1L, 
        20L)), rowFlag = "UNIQUE"), match = list(index = c("14", 
        "15"), multilocus = structure(c("108", "108", "120", "120", 
        "208", "208", "209", "209", "307", "307", "313", "313", "417", 
        "417", "417", "417", "502", "502", "516", "516", "602", "602", 
        "618", "618", "703", "703", "715", "715", "811", "811", "816", 
        "816", "911", "911", "914", "914", "1007", "1007", "1015", 
        "1015"), dim = c(2L, 20L), dimnames = list(NULL, c("LOC1a", 
        "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", 
        "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
        "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), score = c("1", 
        "1"), flags = structure(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(2L, 20L)), perfect = 2L, 
            partial = 0L, psib = c(8.9111773012628e-05, 8.9111773012628e-05
            ), rowFlag = c("", ""), psibNotCalculable = 0L)), list(
            focal = list(index = "16", metaData = NULL, multilocus = structure(c("108", 
            "109", "203", "203", "317", "318", "407", "417", "505", 
            "519", "607", "616", "712", "715", "804", "812", "914", 
            "915", "1015", "1015"), dim = c(1L, 20L), dimnames = list(
                NULL, c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", 
                "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", "LOC6a", 
                "LOC6b", "LOC7a", "LOC7b", "LOC8a", "LOC8b", "LOC9a", 
                "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1), dim = c(1L, 20L)), rowFlag = "UNIQUE"), match = list(
                index = "16", multilocus = structure(c("108", "109", 
                "203", "203", "317", "318", "407", "417", "505", 
                "519", "607", "616", "712", "715", "804", "812", 
                "914", "915", "1015", "1015"), dim = c(1L, 20L), dimnames = list(
                    NULL, c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", 
                    "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", 
                    "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
                    "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"
                    ))), score = "1", flags = structure(c(1, 1, 1, 
                1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
                ), dim = c(1L, 20L)), perfect = 1L, partial = 0L, 
                psib = 7.17718409894783e-05, rowFlag = "", psibNotCalculable = 0L)), 
        list(focal = list(index = "17", metaData = NULL, multilocus = structure(c("103", 
        "109", "208", "208", "306", "307", "404", "413", "502", "519", 
        "602", "603", "709", "717", "816", "816", "911", "914", "1005", 
        "1007"), dim = c(1L, 20L), dimnames = list(NULL, c("LOC1a", 
        "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", 
        "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
        "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(1L, 
        20L)), rowFlag = "UNIQUE"), match = list(index = c("17", 
        "18"), multilocus = structure(c("103", "103", "109", "109", 
        "208", "208", "208", "208", "306", "306", "307", "307", "404", 
        "404", "413", "413", "502", "502", "519", "519", "602", "602", 
        "603", "603", "709", "709", "717", "717", "816", "816", "816", 
        "816", "911", "911", "914", "914", "1005", "1005", "1007", 
        "1007"), dim = c(2L, 20L), dimnames = list(NULL, c("LOC1a", 
        "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", 
        "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
        "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), score = c("1", 
        "1"), flags = structure(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(2L, 20L)), perfect = 2L, 
            partial = 0L, psib = c(6.79610528590075e-05, 6.79610528590075e-05
            ), rowFlag = c("", ""), psibNotCalculable = 0L)), list(
            focal = list(index = "19", metaData = NULL, multilocus = structure(c("108", 
            "114", "201", "207", "-99", "-99", "404", "413", "502", 
            "519", "603", "607", "712", "715", "804", "811", "911", 
            "911", "1015", "1018"), dim = c(1L, 20L), dimnames = list(
                NULL, c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", 
                "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", "LOC6a", 
                "LOC6b", "LOC7a", "LOC7b", "LOC8a", "LOC8b", "LOC9a", 
                "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
            1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1), dim = c(1L, 20L)), rowFlag = "UNIQUE"), match = list(
                index = c("19", "20"), multilocus = structure(c("108", 
                "108", "114", "114", "201", "201", "207", "207", 
                "-99", "306", "-99", "317", "404", "404", "413", 
                "413", "502", "502", "519", "519", "603", "603", 
                "607", "607", "712", "712", "715", "715", "804", 
                "804", "811", "811", "911", "911", "911", "911", 
                "1015", "1015", "1018", "1018"), dim = c(2L, 20L), dimnames = list(
                    NULL, c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", 
                    "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", 
                    "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
                    "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"
                    ))), score = c("1", "0.95"), flags = structure(c(1, 
                1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 
                1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                1, 1, 1, 1, 1), dim = c(2L, 20L)), perfect = 1L, 
                partial = 1L, psib = c(0.000200530393635651, 0.000200530393635651
                ), rowFlag = c("", ""), psibNotCalculable = 0L))), 
        missingCode = "-99", matchThreshold = 0.9, alleleMismatch = 2, 
        missingMethod = 2, focalDatasetN = 12L, comparisonDatasetN = 20L, 
        focalIsComparison = FALSE, numUnclassified = 0L, numMultipleMatches = 0L, 
        unique = structure(list(index = c("1", "3", "5", "7", "8", 
        "9", "11", "13", "14", "16", "17", "19"), multilocus = structure(c("103", 
        "104", "103", "108", "104", "109", "108", "109", "108", "108", 
        "103", "108", "108", "120", "109", "109", "110", "120", "109", 
        "110", "120", "109", "109", "114", "201", "201", "201", "201", 
        "207", "208", "201", "203", "208", "203", "208", "201", "201", 
        "208", "209", "208", "208", "208", "208", "207", "209", "203", 
        "208", "207", "314", "306", "306", "314", "307", "307", "306", 
        "313", "307", "317", "306", "-99", "318", "314", "306", "314", 
        "317", "307", "317", "317", "313", "318", "307", "-99", "405", 
        "407", "408", "404", "417", "407", "404", "407", "417", "407", 
        "404", "404", "417", "407", "414", "417", "417", "417", "413", 
        "417", "417", "417", "413", "413", "514", "502", "501", "501", 
        "516", "505", "502", "505", "502", "505", "502", "502", "519", 
        "502", "502", "514", "516", "519", "514", "519", "516", "519", 
        "519", "519", "603", "607", "603", "607", "603", "607", "603", 
        "607", "602", "607", "602", "603", "618", "616", "607", "618", 
        "603", "618", "607", "618", "618", "616", "603", "607", "709", 
        "713", "706", "706", "717", "703", "703", "706", "703", "712", 
        "709", "712", "715", "715", "706", "715", "719", "709", "719", 
        "719", "715", "715", "717", "715", "804", "804", "804", "804", 
        "804", "804", "812", "811", "811", "804", "816", "804", "816", 
        "816", "804", "811", "812", "805", "816", "811", "816", "812", 
        "816", "811", "911", "912", "914", "914", "907", "914", "911", 
        "914", "911", "914", "911", "911", "914", "914", "918", "914", 
        "914", "914", "911", "915", "914", "915", "914", "911", "1007", 
        "1006", "1006", "1006", "1007", "1007", "1015", "1018", "1007", 
        "1015", "1005", "1015", "1015", "1015", "1006", "1015", "1019", 
        "1015", "1015", "1018", "1015", "1015", "1007", "1018"), dim = c(12L, 
        20L), dimnames = list(NULL, c("LOC1a", "LOC1b", "LOC2a", 
        "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", 
        "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", "LOC8b", "LOC9a", 
        "LOC9b", "LOC10a", "LOC10b"))), uniqueType = c("SINGLETON", 
        "SINGLETON", "SINGLETON", "SINGLETON", "SINGLETON", "SINGLETON", 
        "SINGLETON", "SINGLETON", "SINGLETON", "SINGLETON", "SINGLETON", 
        "SINGLETON"), missingCode = "-99", psib = c(9.84097837711721e-05, 
        7.6700235101921e-05, 4.755381397187e-05, 0.000147527555438071, 
        4.20062196368826e-05, 0.000127630848132018, 0.000100870314036143, 
        3.91984649146532e-05, 8.9111773012628e-05, 7.17718409894783e-05, 
        6.79610528590075e-05, 0.000200530393635651), rowFlag = c("UNIQUE", 
        "UNIQUE", "UNIQUE", "UNIQUE", "UNIQUE", "UNIQUE", "UNIQUE", 
        "UNIQUE", "UNIQUE", "UNIQUE", "UNIQUE", "UNIQUE")), class = "amDataset"), 
        cutHeight = 0.1, consensusMethod = 1, doPsib = "missing", 
        alleleFreq = structure(list(multilocusMap = c(1L, 1L, 2L, 
        2L, 3L, 3L, 4L, 4L, 5L, 5L, 6L, 6L, 7L, 7L, 8L, 8L, 9L, 9L, 
        10L, 10L), loci = list(list(name = "LOC1a-LOC1b", columnNames = c("LOC1a", 
        "LOC1b"), alleleFreq = c("109" = 0.291666666666667, "108" = 0.25, 
        "103" = 0.125, "120" = 0.125, "104" = 0.0833333333333333, 
        "110" = 0.0833333333333333, "114" = 0.0416666666666667), 
            missingFreq = 0, numAlleles = 7L), list(name = "LOC2a-LOC2b", 
            columnNames = c("LOC2a", "LOC2b"), alleleFreq = c("208" = 0.375, 
            "201" = 0.291666666666667, "207" = 0.125, "203" = 0.125, 
            "209" = 0.0833333333333333), missingFreq = 0, numAlleles = 5L), 
            list(name = "LOC3a-LOC3b", columnNames = c("LOC3a", "LOC3b"
            ), alleleFreq = c("306" = 0.227272727272727, "307" = 0.227272727272727, 
            "314" = 0.181818181818182, "317" = 0.181818181818182, 
            "313" = 0.0909090909090909, "318" = 0.0909090909090909
            ), missingFreq = 0.0833333333333333, numAlleles = 6L), 
            list(name = "LOC4a-LOC4b", columnNames = c("LOC4a", "LOC4b"
            ), alleleFreq = c("417" = 0.375, "407" = 0.208333333333333, 
            "404" = 0.166666666666667, "413" = 0.125, "405" = 0.0416666666666667, 
            "408" = 0.0416666666666667, "414" = 0.0416666666666667
            ), missingFreq = 0, numAlleles = 7L), list(name = "LOC5a-LOC5b", 
                columnNames = c("LOC5a", "LOC5b"), alleleFreq = c("502" = 0.291666666666667, 
                "519" = 0.25, "514" = 0.125, "516" = 0.125, "505" = 0.125, 
                "501" = 0.0833333333333333), missingFreq = 0, numAlleles = 6L), 
            list(name = "LOC6a-LOC6b", columnNames = c("LOC6a", "LOC6b"
            ), alleleFreq = c("607" = 0.333333333333333, "603" = 0.291666666666667, 
            "618" = 0.208333333333333, "602" = 0.0833333333333333, 
            "616" = 0.0833333333333333), missingFreq = 0, numAlleles = 5L), 
            list(name = "LOC7a-LOC7b", columnNames = c("LOC7a", "LOC7b"
            ), alleleFreq = c("715" = 0.25, "706" = 0.166666666666667, 
            "709" = 0.125, "703" = 0.125, "719" = 0.125, "717" = 0.0833333333333333, 
            "712" = 0.0833333333333333, "713" = 0.0416666666666667
            ), missingFreq = 0, numAlleles = 8L), list(name = "LOC8a-LOC8b", 
                columnNames = c("LOC8a", "LOC8b"), alleleFreq = c("804" = 0.375, 
                "816" = 0.25, "811" = 0.208333333333333, "812" = 0.125, 
                "805" = 0.0416666666666667), missingFreq = 0, numAlleles = 5L), 
            list(name = "LOC9a-LOC9b", columnNames = c("LOC9a", "LOC9b"
            ), alleleFreq = c("914" = 0.5, "911" = 0.291666666666667, 
            "915" = 0.0833333333333333, "912" = 0.0416666666666667, 
            "907" = 0.0416666666666667, "918" = 0.0416666666666667
            ), missingFreq = 0, numAlleles = 6L), list(name = "LOC10a-LOC10b", 
                columnNames = c("LOC10a", "LOC10b"), alleleFreq = c("1015" = 0.416666666666667, 
                "1007" = 0.208333333333333, "1006" = 0.166666666666667, 
                "1018" = 0.125, "1005" = 0.0416666666666667, "1019" = 0.0416666666666667
                ), missingFreq = 0, numAlleles = 6L))), class = "amAlleleFreq")), class = "amUnique")

---

    Code
      summary.amUnique(uniqueExample1, csv = summaryFile <- tempfile("example1_1.csv"))

---

    structure(list(uniqueGroup = c("1", "1", "2", "2", "3", "3", 
    "4", "5", "6", "6", "7", "7", "8", "9", "9", "10", "11", "11", 
    "12", "12"), rowType = c("UNIQUE", "MATCH", "UNIQUE", "MATCH", 
    "UNIQUE", "MATCH", "UNIQUE", "UNIQUE", "UNIQUE", "MATCH", "UNIQUE", 
    "MATCH", "UNIQUE", "UNIQUE", "MATCH", "UNIQUE", "UNIQUE", "MATCH", 
    "UNIQUE", "MATCH"), uniqueIndex = c("1", "1", "3", "3", "5", 
    "5", "7", "8", "9", "9", "11", "11", "13", "14", "14", "16", 
    "17", "17", "19", "19"), matchIndex = c("1", "2", "3", "4", "5", 
    "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", 
    "17", "18", "19", "20"), nUniqueGroup = c("2", "2", "2", "2", 
    "2", "2", "1", "1", "2", "2", "2", "2", "1", "2", "2", "1", "2", 
    "2", "2", "2"), alleleMismatch = c("2", "2", "2", "2", "2", "2", 
    "2", "2", "2", "2", "2", "2", "2", "2", "2", "2", "2", "2", "2", 
    "2"), matchThreshold = c("0.9", "0.9", "0.9", "0.9", "0.9", "0.9", 
    "0.9", "0.9", "0.9", "0.9", "0.9", "0.9", "0.9", "0.9", "0.9", 
    "0.9", "0.9", "0.9", "0.9", "0.9"), cutHeight = c("0.1", "0.1", 
    "0.1", "0.1", "0.1", "0.1", "0.1", "0.1", "0.1", "0.1", "0.1", 
    "0.1", "0.1", "0.1", "0.1", "0.1", "0.1", "0.1", "0.1", "0.1"
    ), Psib = c("9.84097837711721e-05", "9.84097837711721e-05", "7.6700235101921e-05", 
    "7.6700235101921e-05", "4.755381397187e-05", "4.755381397187e-05", 
    "0.000147527555438071", "4.20062196368826e-05", "0.000127630848132018", 
    "0.000127630848132018", "0.000100870314036143", "0.000100870314036143", 
    "3.91984649146532e-05", "8.9111773012628e-05", "8.9111773012628e-05", 
    "7.17718409894783e-05", "6.79610528590075e-05", "6.79610528590075e-05", 
    "0.000200530393635651", "0.000200530393635651"), score = c("", 
    "1", "", "1", "", "1", "", "", "", "1", "", "1", "", "", "1", 
    "", "", "1", "", "0.95"), LOC1a = c("103", "103", "104", "104", 
    "103", "103", "108", "104", "109", "109", "108", "108", "109", 
    "108", "108", "108", "103", "103", "108", "108"), LOC1b = c("108", 
    "108", "120", "120", "109", "109", "109", "110", "120", "120", 
    "109", "109", "110", "120", "120", "109", "109", "109", "114", 
    "114"), LOC2a = c("201", "201", "201", "201", "201", "201", "201", 
    "207", "208", "208", "201", "201", "203", "208", "208", "203", 
    "208", "208", "201", "201"), LOC2b = c("201", "201", "208", "208", 
    "209", "209", "208", "208", "208", "208", "208", "208", "207", 
    "209", "209", "203", "208", "208", "207", "207"), LOC3a = c("314", 
    "314", "306", "306", "306", "306", "314", "307", "307", "307", 
    "306", "306", "313", "307", "307", "317", "306", "306", "-99", 
    "306"), LOC3b = c("318", "318", "314", "314", "306", "306", "314", 
    "317", "307", "307", "317", "317", "317", "313", "313", "318", 
    "307", "307", "-99", "317"), LOC4a = c("405", "405", "407", "407", 
    "408", "408", "404", "417", "407", "407", "404", "404", "407", 
    "417", "417", "407", "404", "404", "404", "404"), LOC4b = c("417", 
    "417", "407", "407", "414", "414", "417", "417", "417", "417", 
    "413", "413", "417", "417", "417", "417", "413", "413", "413", 
    "413"), LOC5a = c("514", "514", "502", "502", "501", "501", "501", 
    "516", "505", "505", "502", "502", "505", "502", "502", "505", 
    "502", "502", "502", "502"), LOC5b = c("519", "519", "502", "502", 
    "502", "502", "514", "516", "519", "519", "514", "514", "519", 
    "516", "516", "519", "519", "519", "519", "519"), LOC6a = c("603", 
    "603", "607", "607", "603", "603", "607", "603", "607", "607", 
    "603", "603", "607", "602", "602", "607", "602", "602", "603", 
    "603"), LOC6b = c("618", "618", "616", "616", "607", "607", "618", 
    "603", "618", "618", "607", "607", "618", "618", "618", "616", 
    "603", "603", "607", "607"), LOC7a = c("709", "709", "713", "713", 
    "706", "706", "706", "717", "703", "703", "703", "703", "706", 
    "703", "703", "712", "709", "709", "712", "712"), LOC7b = c("715", 
    "715", "715", "715", "706", "706", "715", "719", "709", "709", 
    "719", "719", "719", "715", "715", "715", "717", "717", "715", 
    "715"), LOC8a = c("804", "804", "804", "804", "804", "804", "804", 
    "804", "804", "804", "812", "812", "811", "811", "811", "804", 
    "816", "816", "804", "804"), LOC8b = c("816", "816", "816", "816", 
    "804", "804", "811", "812", "805", "805", "816", "816", "811", 
    "816", "816", "812", "816", "816", "811", "811"), LOC9a = c("911", 
    "911", "912", "912", "914", "914", "914", "907", "914", "914", 
    "911", "911", "914", "911", "911", "914", "911", "911", "911", 
    "911"), LOC9b = c("914", "914", "914", "914", "918", "918", "914", 
    "914", "914", "914", "911", "911", "915", "914", "914", "915", 
    "914", "914", "911", "911"), LOC10a = c("1007", "1007", "1006", 
    "1006", "1006", "1006", "1006", "1007", "1007", "1007", "1015", 
    "1015", "1018", "1007", "1007", "1015", "1005", "1005", "1015", 
    "1015"), LOC10b = c("1015", "1015", "1015", "1015", "1006", "1006", 
    "1015", "1019", "1015", "1015", "1015", "1015", "1018", "1015", 
    "1015", "1015", "1007", "1007", "1018", "1018")), class = "data.frame", row.names = c(NA, 
    -20L))

---

    structure(list(index = c("1", "3", "5", "7", "8", "9", "11", 
    "13", "14", "16", "17", "19"), LOC1a = c("103", "104", "103", 
    "108", "104", "109", "108", "109", "108", "108", "103", "108"
    ), LOC1b = c("108", "120", "109", "109", "110", "120", "109", 
    "110", "120", "109", "109", "114"), LOC2a = c("201", "201", "201", 
    "201", "207", "208", "201", "203", "208", "203", "208", "201"
    ), LOC2b = c("201", "208", "209", "208", "208", "208", "208", 
    "207", "209", "203", "208", "207"), LOC3a = c("314", "306", "306", 
    "314", "307", "307", "306", "313", "307", "317", "306", "-99"
    ), LOC3b = c("318", "314", "306", "314", "317", "307", "317", 
    "317", "313", "318", "307", "-99"), LOC4a = c("405", "407", "408", 
    "404", "417", "407", "404", "407", "417", "407", "404", "404"
    ), LOC4b = c("417", "407", "414", "417", "417", "417", "413", 
    "417", "417", "417", "413", "413"), LOC5a = c("514", "502", "501", 
    "501", "516", "505", "502", "505", "502", "505", "502", "502"
    ), LOC5b = c("519", "502", "502", "514", "516", "519", "514", 
    "519", "516", "519", "519", "519"), LOC6a = c("603", "607", "603", 
    "607", "603", "607", "603", "607", "602", "607", "602", "603"
    ), LOC6b = c("618", "616", "607", "618", "603", "618", "607", 
    "618", "618", "616", "603", "607"), LOC7a = c("709", "713", "706", 
    "706", "717", "703", "703", "706", "703", "712", "709", "712"
    ), LOC7b = c("715", "715", "706", "715", "719", "709", "719", 
    "719", "715", "715", "717", "715"), LOC8a = c("804", "804", "804", 
    "804", "804", "804", "812", "811", "811", "804", "816", "804"
    ), LOC8b = c("816", "816", "804", "811", "812", "805", "816", 
    "811", "816", "812", "816", "811"), LOC9a = c("911", "912", "914", 
    "914", "907", "914", "911", "914", "911", "914", "911", "911"
    ), LOC9b = c("914", "914", "918", "914", "914", "914", "911", 
    "915", "914", "915", "914", "911"), LOC10a = c("1007", "1006", 
    "1006", "1006", "1007", "1007", "1015", "1018", "1007", "1015", 
    "1005", "1015"), LOC10b = c("1015", "1015", "1006", "1015", "1019", 
    "1015", "1015", "1018", "1015", "1015", "1007", "1018")), class = "data.frame", row.names = c(NA, 
    -12L))

---

    structure(list(index = c("1", "2", "3", "4", "5", "6", "7", "8", 
    "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
    "20"), metaData = c("AAA", "AAA", "AAB", "AAB", "AAC", "AAC", 
    "AAD", "AAE", "AAF", "AAF", "AAG", "AAG", "AAH", "AAI", "AAI", 
    "AAJ", "AAK", "AAK", "AAL", "AAL"), multilocus = structure(c("103", 
    "103", "104", "104", "103", "103", "108", "104", "109", "109", 
    "108", "108", "109", "108", "108", "108", "103", "103", "108", 
    "108", "108", "108", "120", "120", "109", "109", "109", "110", 
    "120", "120", "109", "109", "110", "120", "120", "109", "109", 
    "109", "114", "114", "201", "201", "201", "201", "201", "201", 
    "201", "207", "208", "208", "201", "201", "203", "208", "208", 
    "203", "208", "208", "201", "201", "201", "201", "208", "208", 
    "209", "209", "208", "208", "208", "208", "208", "208", "207", 
    "209", "209", "203", "208", "208", "207", "207", "314", "314", 
    "306", "306", "306", "306", "314", "307", "307", "307", "306", 
    "306", "313", "307", "307", "317", "306", "306", "-99", "306", 
    "318", "318", "314", "314", "306", "306", "314", "317", "307", 
    "307", "317", "317", "317", "313", "313", "318", "307", "307", 
    "-99", "317", "405", "405", "407", "407", "408", "408", "404", 
    "417", "407", "407", "404", "404", "407", "417", "417", "407", 
    "404", "404", "404", "404", "417", "417", "407", "407", "414", 
    "414", "417", "417", "417", "417", "413", "413", "417", "417", 
    "417", "417", "413", "413", "413", "413", "514", "514", "502", 
    "502", "501", "501", "501", "516", "505", "505", "502", "502", 
    "505", "502", "502", "505", "502", "502", "502", "502", "519", 
    "519", "502", "502", "502", "502", "514", "516", "519", "519", 
    "514", "514", "519", "516", "516", "519", "519", "519", "519", 
    "519", "603", "603", "607", "607", "603", "603", "607", "603", 
    "607", "607", "603", "603", "607", "602", "602", "607", "602", 
    "602", "603", "603", "618", "618", "616", "616", "607", "607", 
    "618", "603", "618", "618", "607", "607", "618", "618", "618", 
    "616", "603", "603", "607", "607", "709", "709", "713", "713", 
    "706", "706", "706", "717", "703", "703", "703", "703", "706", 
    "703", "703", "712", "709", "709", "712", "712", "715", "715", 
    "715", "715", "706", "706", "715", "719", "709", "709", "719", 
    "719", "719", "715", "715", "715", "717", "717", "715", "715", 
    "804", "804", "804", "804", "804", "804", "804", "804", "804", 
    "804", "812", "812", "811", "811", "811", "804", "816", "816", 
    "804", "804", "816", "816", "816", "816", "804", "804", "811", 
    "812", "805", "805", "816", "816", "811", "816", "816", "812", 
    "816", "816", "811", "811", "911", "911", "912", "912", "914", 
    "914", "914", "907", "914", "914", "911", "911", "914", "911", 
    "911", "914", "911", "911", "911", "911", "914", "914", "914", 
    "914", "918", "918", "914", "914", "914", "914", "911", "911", 
    "915", "914", "914", "915", "914", "914", "911", "911", "1007", 
    "1007", "1006", "1006", "1006", "1006", "1006", "1007", "1007", 
    "1007", "1015", "1015", "1018", "1007", "1007", "1015", "1005", 
    "1005", "1015", "1015", "1015", "1015", "1015", "1015", "1006", 
    "1006", "1015", "1019", "1015", "1015", "1015", "1015", "1018", 
    "1015", "1015", "1015", "1007", "1007", "1018", "1018"), dim = c(20L, 
    20L), dimnames = list(NULL, c("LOC1a", "LOC1b", "LOC2a", "LOC2b", 
    "LOC3a", "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", "LOC6a", 
    "LOC6b", "LOC7a", "LOC7b", "LOC8a", "LOC8b", "LOC9a", "LOC9b", 
    "LOC10a", "LOC10b"))), missingCode = "-99"), class = "amDataset")

---

    structure(list(pairwise = list(list(focal = list(index = "1", 
        metaData = "AAA", multilocus = structure(c("103", "108", 
        "201", "201", "314", "318", "405", "417", "514", "519", "603", 
        "618", "709", "715", "804", "816", "911", "914", "1007", 
        "1015"), dim = c(1L, 20L), dimnames = list(NULL, c("LOC1a", 
        "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", 
        "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
        "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(1L, 
        20L)), rowFlag = "UNIQUE"), match = list(index = c("1", "2"
    ), metaData = c("AAA", "AAA"), multilocus = structure(c("103", 
    "103", "108", "108", "201", "201", "201", "201", "314", "314", 
    "318", "318", "405", "405", "417", "417", "514", "514", "519", 
    "519", "603", "603", "618", "618", "709", "709", "715", "715", 
    "804", "804", "816", "816", "911", "911", "914", "914", "1007", 
    "1007", "1015", "1015"), dim = c(2L, 20L), dimnames = list(NULL, 
        c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", 
        "LOC4b", "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", 
        "LOC8a", "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), 
        score = c("1", "1"), flags = structure(c(1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(2L, 
        20L)), perfect = 2L, partial = 0L, psib = c(9.84097837711721e-05, 
        9.84097837711721e-05), rowFlag = c("", ""), psibNotCalculable = 0L)), 
        list(focal = list(index = "3", metaData = "AAB", multilocus = structure(c("104", 
        "120", "201", "208", "306", "314", "407", "407", "502", "502", 
        "607", "616", "713", "715", "804", "816", "912", "914", "1006", 
        "1015"), dim = c(1L, 20L), dimnames = list(NULL, c("LOC1a", 
        "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", 
        "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
        "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(1L, 
        20L)), rowFlag = "UNIQUE"), match = list(index = c("3", "4"
        ), metaData = c("AAB", "AAB"), multilocus = structure(c("104", 
        "104", "120", "120", "201", "201", "208", "208", "306", "306", 
        "314", "314", "407", "407", "407", "407", "502", "502", "502", 
        "502", "607", "607", "616", "616", "713", "713", "715", "715", 
        "804", "804", "816", "816", "912", "912", "914", "914", "1006", 
        "1006", "1015", "1015"), dim = c(2L, 20L), dimnames = list(
            NULL, c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", 
            "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", "LOC6a", 
            "LOC6b", "LOC7a", "LOC7b", "LOC8a", "LOC8b", "LOC9a", 
            "LOC9b", "LOC10a", "LOC10b"))), score = c("1", "1"), 
            flags = structure(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(2L, 20L)), 
            perfect = 2L, partial = 0L, psib = c(7.6700235101921e-05, 
            7.6700235101921e-05), rowFlag = c("", ""), psibNotCalculable = 0L)), 
        list(focal = list(index = "5", metaData = "AAC", multilocus = structure(c("103", 
        "109", "201", "209", "306", "306", "408", "414", "501", "502", 
        "603", "607", "706", "706", "804", "804", "914", "918", "1006", 
        "1006"), dim = c(1L, 20L), dimnames = list(NULL, c("LOC1a", 
        "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", 
        "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
        "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(1L, 
        20L)), rowFlag = "UNIQUE"), match = list(index = c("5", "6"
        ), metaData = c("AAC", "AAC"), multilocus = structure(c("103", 
        "103", "109", "109", "201", "201", "209", "209", "306", "306", 
        "306", "306", "408", "408", "414", "414", "501", "501", "502", 
        "502", "603", "603", "607", "607", "706", "706", "706", "706", 
        "804", "804", "804", "804", "914", "914", "918", "918", "1006", 
        "1006", "1006", "1006"), dim = c(2L, 20L), dimnames = list(
            NULL, c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", 
            "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", "LOC6a", 
            "LOC6b", "LOC7a", "LOC7b", "LOC8a", "LOC8b", "LOC9a", 
            "LOC9b", "LOC10a", "LOC10b"))), score = c("1", "1"), 
            flags = structure(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(2L, 20L)), 
            perfect = 2L, partial = 0L, psib = c(4.755381397187e-05, 
            4.755381397187e-05), rowFlag = c("", ""), psibNotCalculable = 0L)), 
        list(focal = list(index = "7", metaData = "AAD", multilocus = structure(c("108", 
        "109", "201", "208", "314", "314", "404", "417", "501", "514", 
        "607", "618", "706", "715", "804", "811", "914", "914", "1006", 
        "1015"), dim = c(1L, 20L), dimnames = list(NULL, c("LOC1a", 
        "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", 
        "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
        "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(1L, 
        20L)), rowFlag = "UNIQUE"), match = list(index = "7", metaData = "AAD", 
            multilocus = structure(c("108", "109", "201", "208", 
            "314", "314", "404", "417", "501", "514", "607", "618", 
            "706", "715", "804", "811", "914", "914", "1006", "1015"
            ), dim = c(1L, 20L), dimnames = list(NULL, c("LOC1a", 
            "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", 
            "LOC4b", "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", 
            "LOC7b", "LOC8a", "LOC8b", "LOC9a", "LOC9b", "LOC10a", 
            "LOC10b"))), score = "1", flags = structure(c(1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(1L, 
            20L)), perfect = 1L, partial = 0L, psib = 0.000147527555438071, 
            rowFlag = "", psibNotCalculable = 0L)), list(focal = list(
            index = "8", metaData = "AAE", multilocus = structure(c("104", 
            "110", "207", "208", "307", "317", "417", "417", "516", 
            "516", "603", "603", "717", "719", "804", "812", "907", 
            "914", "1007", "1019"), dim = c(1L, 20L), dimnames = list(
                NULL, c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", 
                "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", "LOC6a", 
                "LOC6b", "LOC7a", "LOC7b", "LOC8a", "LOC8b", "LOC9a", 
                "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1), dim = c(1L, 20L)), rowFlag = "UNIQUE"), match = list(
            index = "8", metaData = "AAE", multilocus = structure(c("104", 
            "110", "207", "208", "307", "317", "417", "417", "516", 
            "516", "603", "603", "717", "719", "804", "812", "907", 
            "914", "1007", "1019"), dim = c(1L, 20L), dimnames = list(
                NULL, c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", 
                "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", "LOC6a", 
                "LOC6b", "LOC7a", "LOC7b", "LOC8a", "LOC8b", "LOC9a", 
                "LOC9b", "LOC10a", "LOC10b"))), score = "1", flags = structure(c(1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1), dim = c(1L, 20L)), perfect = 1L, partial = 0L, psib = 4.20062196368826e-05, 
            rowFlag = "", psibNotCalculable = 0L)), list(focal = list(
            index = "9", metaData = "AAF", multilocus = structure(c("109", 
            "120", "208", "208", "307", "307", "407", "417", "505", 
            "519", "607", "618", "703", "709", "804", "805", "914", 
            "914", "1007", "1015"), dim = c(1L, 20L), dimnames = list(
                NULL, c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", 
                "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", "LOC6a", 
                "LOC6b", "LOC7a", "LOC7b", "LOC8a", "LOC8b", "LOC9a", 
                "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1), dim = c(1L, 20L)), rowFlag = "UNIQUE"), match = list(
            index = c("9", "10"), metaData = c("AAF", "AAF"), multilocus = structure(c("109", 
            "109", "120", "120", "208", "208", "208", "208", "307", 
            "307", "307", "307", "407", "407", "417", "417", "505", 
            "505", "519", "519", "607", "607", "618", "618", "703", 
            "703", "709", "709", "804", "804", "805", "805", "914", 
            "914", "914", "914", "1007", "1007", "1015", "1015"), dim = c(2L, 
            20L), dimnames = list(NULL, c("LOC1a", "LOC1b", "LOC2a", 
            "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", "LOC5a", 
            "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
            "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), score = c("1", 
            "1"), flags = structure(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(2L, 20L
            )), perfect = 2L, partial = 0L, psib = c(0.000127630848132018, 
            0.000127630848132018), rowFlag = c("", ""), psibNotCalculable = 0L)), 
        list(focal = list(index = "11", metaData = "AAG", multilocus = structure(c("108", 
        "109", "201", "208", "306", "317", "404", "413", "502", "514", 
        "603", "607", "703", "719", "812", "816", "911", "911", "1015", 
        "1015"), dim = c(1L, 20L), dimnames = list(NULL, c("LOC1a", 
        "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", 
        "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
        "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(1L, 
        20L)), rowFlag = "UNIQUE"), match = list(index = c("11", 
        "12"), metaData = c("AAG", "AAG"), multilocus = structure(c("108", 
        "108", "109", "109", "201", "201", "208", "208", "306", "306", 
        "317", "317", "404", "404", "413", "413", "502", "502", "514", 
        "514", "603", "603", "607", "607", "703", "703", "719", "719", 
        "812", "812", "816", "816", "911", "911", "911", "911", "1015", 
        "1015", "1015", "1015"), dim = c(2L, 20L), dimnames = list(
            NULL, c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", 
            "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", "LOC6a", 
            "LOC6b", "LOC7a", "LOC7b", "LOC8a", "LOC8b", "LOC9a", 
            "LOC9b", "LOC10a", "LOC10b"))), score = c("1", "1"), 
            flags = structure(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(2L, 20L)), 
            perfect = 2L, partial = 0L, psib = c(0.000100870314036143, 
            0.000100870314036143), rowFlag = c("", ""), psibNotCalculable = 0L)), 
        list(focal = list(index = "13", metaData = "AAH", multilocus = structure(c("109", 
        "110", "203", "207", "313", "317", "407", "417", "505", "519", 
        "607", "618", "706", "719", "811", "811", "914", "915", "1018", 
        "1018"), dim = c(1L, 20L), dimnames = list(NULL, c("LOC1a", 
        "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", 
        "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
        "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(1L, 
        20L)), rowFlag = "UNIQUE"), match = list(index = "13", metaData = "AAH", 
            multilocus = structure(c("109", "110", "203", "207", 
            "313", "317", "407", "417", "505", "519", "607", "618", 
            "706", "719", "811", "811", "914", "915", "1018", "1018"
            ), dim = c(1L, 20L), dimnames = list(NULL, c("LOC1a", 
            "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", 
            "LOC4b", "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", 
            "LOC7b", "LOC8a", "LOC8b", "LOC9a", "LOC9b", "LOC10a", 
            "LOC10b"))), score = "1", flags = structure(c(1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(1L, 
            20L)), perfect = 1L, partial = 0L, psib = 3.91984649146532e-05, 
            rowFlag = "", psibNotCalculable = 0L)), list(focal = list(
            index = "14", metaData = "AAI", multilocus = structure(c("108", 
            "120", "208", "209", "307", "313", "417", "417", "502", 
            "516", "602", "618", "703", "715", "811", "816", "911", 
            "914", "1007", "1015"), dim = c(1L, 20L), dimnames = list(
                NULL, c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", 
                "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", "LOC6a", 
                "LOC6b", "LOC7a", "LOC7b", "LOC8a", "LOC8b", "LOC9a", 
                "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1), dim = c(1L, 20L)), rowFlag = "UNIQUE"), match = list(
            index = c("14", "15"), metaData = c("AAI", "AAI"), multilocus = structure(c("108", 
            "108", "120", "120", "208", "208", "209", "209", "307", 
            "307", "313", "313", "417", "417", "417", "417", "502", 
            "502", "516", "516", "602", "602", "618", "618", "703", 
            "703", "715", "715", "811", "811", "816", "816", "911", 
            "911", "914", "914", "1007", "1007", "1015", "1015"), dim = c(2L, 
            20L), dimnames = list(NULL, c("LOC1a", "LOC1b", "LOC2a", 
            "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", "LOC5a", 
            "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
            "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), score = c("1", 
            "1"), flags = structure(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(2L, 20L
            )), perfect = 2L, partial = 0L, psib = c(8.9111773012628e-05, 
            8.9111773012628e-05), rowFlag = c("", ""), psibNotCalculable = 0L)), 
        list(focal = list(index = "16", metaData = "AAJ", multilocus = structure(c("108", 
        "109", "203", "203", "317", "318", "407", "417", "505", "519", 
        "607", "616", "712", "715", "804", "812", "914", "915", "1015", 
        "1015"), dim = c(1L, 20L), dimnames = list(NULL, c("LOC1a", 
        "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", 
        "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
        "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(1L, 
        20L)), rowFlag = "UNIQUE"), match = list(index = "16", metaData = "AAJ", 
            multilocus = structure(c("108", "109", "203", "203", 
            "317", "318", "407", "417", "505", "519", "607", "616", 
            "712", "715", "804", "812", "914", "915", "1015", "1015"
            ), dim = c(1L, 20L), dimnames = list(NULL, c("LOC1a", 
            "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", 
            "LOC4b", "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", 
            "LOC7b", "LOC8a", "LOC8b", "LOC9a", "LOC9b", "LOC10a", 
            "LOC10b"))), score = "1", flags = structure(c(1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(1L, 
            20L)), perfect = 1L, partial = 0L, psib = 7.17718409894783e-05, 
            rowFlag = "", psibNotCalculable = 0L)), list(focal = list(
            index = "17", metaData = "AAK", multilocus = structure(c("103", 
            "109", "208", "208", "306", "307", "404", "413", "502", 
            "519", "602", "603", "709", "717", "816", "816", "911", 
            "914", "1005", "1007"), dim = c(1L, 20L), dimnames = list(
                NULL, c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", 
                "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", "LOC6a", 
                "LOC6b", "LOC7a", "LOC7b", "LOC8a", "LOC8b", "LOC9a", 
                "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1), dim = c(1L, 20L)), rowFlag = "UNIQUE"), match = list(
            index = c("17", "18"), metaData = c("AAK", "AAK"), multilocus = structure(c("103", 
            "103", "109", "109", "208", "208", "208", "208", "306", 
            "306", "307", "307", "404", "404", "413", "413", "502", 
            "502", "519", "519", "602", "602", "603", "603", "709", 
            "709", "717", "717", "816", "816", "816", "816", "911", 
            "911", "914", "914", "1005", "1005", "1007", "1007"), dim = c(2L, 
            20L), dimnames = list(NULL, c("LOC1a", "LOC1b", "LOC2a", 
            "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", "LOC5a", 
            "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
            "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), score = c("1", 
            "1"), flags = structure(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(2L, 20L
            )), perfect = 2L, partial = 0L, psib = c(6.79610528590075e-05, 
            6.79610528590075e-05), rowFlag = c("", ""), psibNotCalculable = 0L)), 
        list(focal = list(index = "19", metaData = "AAL", multilocus = structure(c("108", 
        "114", "201", "207", "-99", "-99", "404", "413", "502", "519", 
        "603", "607", "712", "715", "804", "811", "911", "911", "1015", 
        "1018"), dim = c(1L, 20L), dimnames = list(NULL, c("LOC1a", 
        "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", "LOC4b", 
        "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", "LOC7b", "LOC8a", 
        "LOC8b", "LOC9a", "LOC9b", "LOC10a", "LOC10b"))), flags = structure(c(1, 
        1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(1L, 
        20L)), rowFlag = "UNIQUE"), match = list(index = c("19", 
        "20"), metaData = c("AAL", "AAL"), multilocus = structure(c("108", 
        "108", "114", "114", "201", "201", "207", "207", "-99", "306", 
        "-99", "317", "404", "404", "413", "413", "502", "502", "519", 
        "519", "603", "603", "607", "607", "712", "712", "715", "715", 
        "804", "804", "811", "811", "911", "911", "911", "911", "1015", 
        "1015", "1018", "1018"), dim = c(2L, 20L), dimnames = list(
            NULL, c("LOC1a", "LOC1b", "LOC2a", "LOC2b", "LOC3a", 
            "LOC3b", "LOC4a", "LOC4b", "LOC5a", "LOC5b", "LOC6a", 
            "LOC6b", "LOC7a", "LOC7b", "LOC8a", "LOC8b", "LOC9a", 
            "LOC9b", "LOC10a", "LOC10b"))), score = c("1", "0.95"
        ), flags = structure(c(1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1), dim = c(2L, 20L)), perfect = 1L, 
            partial = 1L, psib = c(0.000200530393635651, 0.000200530393635651
            ), rowFlag = c("", ""), psibNotCalculable = 0L))), missingCode = "-99", 
        matchThreshold = 0.9, alleleMismatch = 2, missingMethod = 2, 
        focalDatasetN = 12L, comparisonDatasetN = 20L, focalIsComparison = FALSE, 
        numUnclassified = 0L, numMultipleMatches = 0L, unique = structure(list(
            index = c("1", "3", "5", "7", "8", "9", "11", "13", "14", 
            "16", "17", "19"), metaData = c("AAA", "AAB", "AAC", 
            "AAD", "AAE", "AAF", "AAG", "AAH", "AAI", "AAJ", "AAK", 
            "AAL"), multilocus = structure(c("103", "104", "103", 
            "108", "104", "109", "108", "109", "108", "108", "103", 
            "108", "108", "120", "109", "109", "110", "120", "109", 
            "110", "120", "109", "109", "114", "201", "201", "201", 
            "201", "207", "208", "201", "203", "208", "203", "208", 
            "201", "201", "208", "209", "208", "208", "208", "208", 
            "207", "209", "203", "208", "207", "314", "306", "306", 
            "314", "307", "307", "306", "313", "307", "317", "306", 
            "-99", "318", "314", "306", "314", "317", "307", "317", 
            "317", "313", "318", "307", "-99", "405", "407", "408", 
            "404", "417", "407", "404", "407", "417", "407", "404", 
            "404", "417", "407", "414", "417", "417", "417", "413", 
            "417", "417", "417", "413", "413", "514", "502", "501", 
            "501", "516", "505", "502", "505", "502", "505", "502", 
            "502", "519", "502", "502", "514", "516", "519", "514", 
            "519", "516", "519", "519", "519", "603", "607", "603", 
            "607", "603", "607", "603", "607", "602", "607", "602", 
            "603", "618", "616", "607", "618", "603", "618", "607", 
            "618", "618", "616", "603", "607", "709", "713", "706", 
            "706", "717", "703", "703", "706", "703", "712", "709", 
            "712", "715", "715", "706", "715", "719", "709", "719", 
            "719", "715", "715", "717", "715", "804", "804", "804", 
            "804", "804", "804", "812", "811", "811", "804", "816", 
            "804", "816", "816", "804", "811", "812", "805", "816", 
            "811", "816", "812", "816", "811", "911", "912", "914", 
            "914", "907", "914", "911", "914", "911", "914", "911", 
            "911", "914", "914", "918", "914", "914", "914", "911", 
            "915", "914", "915", "914", "911", "1007", "1006", "1006", 
            "1006", "1007", "1007", "1015", "1018", "1007", "1015", 
            "1005", "1015", "1015", "1015", "1006", "1015", "1019", 
            "1015", "1015", "1018", "1015", "1015", "1007", "1018"
            ), dim = c(12L, 20L), dimnames = list(NULL, c("LOC1a", 
            "LOC1b", "LOC2a", "LOC2b", "LOC3a", "LOC3b", "LOC4a", 
            "LOC4b", "LOC5a", "LOC5b", "LOC6a", "LOC6b", "LOC7a", 
            "LOC7b", "LOC8a", "LOC8b", "LOC9a", "LOC9b", "LOC10a", 
            "LOC10b"))), uniqueType = c("SINGLETON", "SINGLETON", 
            "SINGLETON", "SINGLETON", "SINGLETON", "SINGLETON", "SINGLETON", 
            "SINGLETON", "SINGLETON", "SINGLETON", "SINGLETON", "SINGLETON"
            ), missingCode = "-99", psib = c(9.84097837711721e-05, 
            7.6700235101921e-05, 4.755381397187e-05, 0.000147527555438071, 
            4.20062196368826e-05, 0.000127630848132018, 0.000100870314036143, 
            3.91984649146532e-05, 8.9111773012628e-05, 7.17718409894783e-05, 
            6.79610528590075e-05, 0.000200530393635651), rowFlag = c("UNIQUE", 
            "UNIQUE", "UNIQUE", "UNIQUE", "UNIQUE", "UNIQUE", "UNIQUE", 
            "UNIQUE", "UNIQUE", "UNIQUE", "UNIQUE", "UNIQUE")), class = "amDataset"), 
        cutHeight = 0.1, consensusMethod = 1, doPsib = "missing", 
        alleleFreq = structure(list(multilocusMap = c(1L, 1L, 2L, 
        2L, 3L, 3L, 4L, 4L, 5L, 5L, 6L, 6L, 7L, 7L, 8L, 8L, 9L, 9L, 
        10L, 10L), loci = list(list(name = "LOC1a-LOC1b", columnNames = c("LOC1a", 
        "LOC1b"), alleleFreq = c("109" = 0.291666666666667, "108" = 0.25, 
        "103" = 0.125, "120" = 0.125, "104" = 0.0833333333333333, 
        "110" = 0.0833333333333333, "114" = 0.0416666666666667), 
            missingFreq = 0, numAlleles = 7L), list(name = "LOC2a-LOC2b", 
            columnNames = c("LOC2a", "LOC2b"), alleleFreq = c("208" = 0.375, 
            "201" = 0.291666666666667, "207" = 0.125, "203" = 0.125, 
            "209" = 0.0833333333333333), missingFreq = 0, numAlleles = 5L), 
            list(name = "LOC3a-LOC3b", columnNames = c("LOC3a", "LOC3b"
            ), alleleFreq = c("306" = 0.227272727272727, "307" = 0.227272727272727, 
            "314" = 0.181818181818182, "317" = 0.181818181818182, 
            "313" = 0.0909090909090909, "318" = 0.0909090909090909
            ), missingFreq = 0.0833333333333333, numAlleles = 6L), 
            list(name = "LOC4a-LOC4b", columnNames = c("LOC4a", "LOC4b"
            ), alleleFreq = c("417" = 0.375, "407" = 0.208333333333333, 
            "404" = 0.166666666666667, "413" = 0.125, "405" = 0.0416666666666667, 
            "408" = 0.0416666666666667, "414" = 0.0416666666666667
            ), missingFreq = 0, numAlleles = 7L), list(name = "LOC5a-LOC5b", 
                columnNames = c("LOC5a", "LOC5b"), alleleFreq = c("502" = 0.291666666666667, 
                "519" = 0.25, "514" = 0.125, "516" = 0.125, "505" = 0.125, 
                "501" = 0.0833333333333333), missingFreq = 0, numAlleles = 6L), 
            list(name = "LOC6a-LOC6b", columnNames = c("LOC6a", "LOC6b"
            ), alleleFreq = c("607" = 0.333333333333333, "603" = 0.291666666666667, 
            "618" = 0.208333333333333, "602" = 0.0833333333333333, 
            "616" = 0.0833333333333333), missingFreq = 0, numAlleles = 5L), 
            list(name = "LOC7a-LOC7b", columnNames = c("LOC7a", "LOC7b"
            ), alleleFreq = c("715" = 0.25, "706" = 0.166666666666667, 
            "709" = 0.125, "703" = 0.125, "719" = 0.125, "717" = 0.0833333333333333, 
            "712" = 0.0833333333333333, "713" = 0.0416666666666667
            ), missingFreq = 0, numAlleles = 8L), list(name = "LOC8a-LOC8b", 
                columnNames = c("LOC8a", "LOC8b"), alleleFreq = c("804" = 0.375, 
                "816" = 0.25, "811" = 0.208333333333333, "812" = 0.125, 
                "805" = 0.0416666666666667), missingFreq = 0, numAlleles = 5L), 
            list(name = "LOC9a-LOC9b", columnNames = c("LOC9a", "LOC9b"
            ), alleleFreq = c("914" = 0.5, "911" = 0.291666666666667, 
            "915" = 0.0833333333333333, "912" = 0.0416666666666667, 
            "907" = 0.0416666666666667, "918" = 0.0416666666666667
            ), missingFreq = 0, numAlleles = 6L), list(name = "LOC10a-LOC10b", 
                columnNames = c("LOC10a", "LOC10b"), alleleFreq = c("1015" = 0.416666666666667, 
                "1007" = 0.208333333333333, "1006" = 0.166666666666667, 
                "1018" = 0.125, "1005" = 0.0416666666666667, "1019" = 0.0416666666666667
                ), missingFreq = 0, numAlleles = 6L))), class = "amAlleleFreq")), class = "amUnique")

