% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{fit_distr}
\alias{fit_distr}
\title{Fit distribution to data}
\usage{
fit_distr(x, dist_name, na.rm = TRUE)
}
\arguments{
\item{x}{\verb{[numeric(>1)]} \cr The observed data.}

\item{dist_name}{\verb{[character(1)]\{"exp", "gamma", "unif", "vonmises"\}} \cr The name of the
distribution.}

\item{na.rm}{\verb{[logical(1)=TRUE]} \cr Indicating whether \code{NA} should be
removed before fitting the distribution.}
}
\value{
An \code{amt_distr} object, which consists of a list with the \code{name} of
the distribution and its parameters (saved in \code{params}).
}
\description{
Wrapper to fit a distribution to data. Currently implemented distributions
are the exponential distribution (\code{exp}), the gamma distribution (\code{gamma})
and the von Mises distribution (\code{vonmises}).
}
\examples{
set.seed(123)
dat <- rexp(1e3, 2)
fit_distr(dat, "exp")
}
