% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleaning.R
\name{calculate_sdr}
\alias{calculate_sdr}
\title{Calculate SDR}
\usage{
calculate_sdr(speed = 50, time, speed_unit = c("km/h", "m/s"))
}
\arguments{
\item{speed}{\verb{[numeric]} A speed given in either km/h or m/s.}

\item{time}{\verb{[Period]} A \code{lubridate} \code{Period} for which the \code{speed}
can be sustained.}

\item{speed_unit}{\verb{[character]} The unit in which \code{speed} is given. Should
be either \code{"km/h"} or \code{"m/s"}.}
}
\value{
Returns a numeric vector (of length 1) with the SDR in \code{m^2/s}.
}
\description{
Calculates squared displacement rate for a given speed and duration
}
\examples{

# Assume a cheetah can sprint 100 km/h for 60 seconds
calculate_sdr(speed = 100, time = seconds(60), speed_unit = "km/h")
# 46296.3 m^2/s

# What is expected displacement in 1 h at that SDR?
get_displacement(46296.3, hours(1))
# 12909.95 m = 12.9 km/h (much slower than sprint speed!)

}
\seealso{
\code{\link{get_displacement}()}
}
\author{
Johannes Signer and Brian J. Smith
}
