% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_network_from_interactions.R
\name{network_from_interactions}
\alias{network_from_interactions}
\title{Function to obtain a network structure from interactions dataframe}
\usage{
network_from_interactions(species_raw, interactions, n_cores = 1)
}
\arguments{
\item{species_raw}{A dataframe consisting of raw GPS observations.
It should have at least four columns namely "animal_id", "datetime", "latitude|_rad", and "longitude_rad". 
"latitude|_rad", and "longitude_rad" are latitude and longitude values in radians respectively. See function "get_coordinates_in_radian"
to get these values.}

\item{interactions}{A dataframe of interactions obtained from raw GPS observations using the function "get_interactions"}

\item{n_cores}{Number of cores for parallel processing, default is 1}
}
\value{
An object of class igraph
}
\description{
Function to obtain a network structure from interactions dataframe
}
\examples{
data(elk_data_2010, elk_interactions_2010)
network_from_interactions(elk_data_2010, elk_interactions_2010)

}
