% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.strat.R
\name{sample.strat}
\alias{sample.strat}
\title{Demonstration for the stratified sampling}
\usage{
sample.strat(pop = ceiling(10 * runif(10, 0.5, 1)), size = ceiling(pop * 
    runif(length(pop), 0, 0.5)), p.col = c("blue", "red"), p.cex = c(1, 3), 
    ...)
}
\arguments{
\item{pop}{a vector for the size of each stratum in the population.}

\item{size}{a corresponding vector for the sample size in each stratum
(recycled if necessary).}

\item{p.col, p.cex}{different colors /magnification rate to annotate the
population and the sample}

\item{\dots}{other arguments passed to \code{\link{rect}} to annotate the
``strata''}
}
\value{
None (invisible `\code{NULL}').
}
\description{
Each rectangle stands for a stratum, and the simple random sampling without
replacement is performed within each stratum. The points being sampled are
marked out (by red circles by default).
}
\seealso{
\code{\link{sample}}, \code{\link{sample.simple}},
  \code{\link{sample.cluster}}, \code{\link{sample.ratio}},
  \code{\link{sample.system}}
}
\author{
Yihui Xie
}
