% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_geoms.R
\name{geom_tallrect}
\alias{geom_tallrect}
\title{ggplot2 geom with xmin and xmax aesthetics that covers the entire y range, useful for clickSelects background elements.}
\usage{
geom_tallrect(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", ..., na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)
}
\arguments{
\item{mapping}{aesthetic mapping}

\item{data}{data set}

\item{stat}{statistic mapping, defaults to identity}

\item{position}{position mapping, defaults to identity}

\item{...}{other arguments}

\item{na.rm}{remove missing values?}

\item{show.legend}{TRUE or FALSE}

\item{inherit.aes}{TRUE or FALSE}
}
\value{
ggplot2 layer
}
\description{
ggplot2 geom with xmin and xmax aesthetics that covers the entire y range, useful for clickSelects background elements.
}
\examples{
library(animint2)

## Example: 2 plots, 2 selectors, but only interacting with 1 plot.
data(breakpoints)
only.error <- subset(breakpoints$error,type=="E")
only.segments <- subset(only.error,bases.per.probe==bases.per.probe[1])
signal.colors <- c(estimate="#0adb0a",
                   latent="#0098ef")
breakpointError <- 
  list(signal=ggplot()+
         geom_point(aes(position, signal),
                    showSelected="bases.per.probe",
                    data=breakpoints$signals)+
         geom_line(aes(position, signal), colour=signal.colors[["latent"]],
                   data=breakpoints$imprecision)+
         geom_segment(aes(first.base, mean, xend=last.base, yend=mean),
                      showSelected=c("segments", "bases.per.probe"),
                      colour=signal.colors[["estimate"]],
                      data=breakpoints$segments)+
         geom_vline(aes(xintercept=base),
                    showSelected=c("segments", "bases.per.probe"),
                    colour=signal.colors[["estimate"]],
                    linetype="dashed",
                    data=breakpoints$breaks),
       error=ggplot()+
         geom_vline(aes(xintercept=segments), clickSelects="segments",
                    data=only.segments, lwd=17, alpha=1/2)+
         geom_line(aes(segments, error, group=bases.per.probe),
                   clickSelects="bases.per.probe",
                   data=only.error, lwd=4))
animint2dir(breakpointError)
}
