% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-dodge.r
\name{position_dodge}
\alias{position_dodge}
\title{Adjust position by dodging overlaps to the side.}
\usage{
position_dodge(width = NULL)
}
\arguments{
\item{width}{Dodging width, when different to the width of the individual
elements. This is useful when you want to align narrow geoms with wider
geoms. See the examples for a use case.}
}
\description{
Adjust position by dodging overlaps to the side.
}
\examples{
ggplot(mtcars, aes(factor(cyl), fill = factor(vs))) +
  geom_bar(position = "dodge")
\donttest{
ggplot(diamonds, aes(price, fill = cut)) +
  geom_histogram(position="dodge")
# see ?geom_boxplot and ?geom_bar for more examples

# To dodge items with different widths, you need to be explicit
df <- data.frame(x = c("a","a","b","b"), y = 2:5, g = rep(1:2, 2))
p <- ggplot(df, aes(x, y, group = g)) +
  geom_bar(
    stat = "identity", position = "dodge",
    fill = "grey50", colour = "black"
  )
p

# A line range has no width:
p + geom_linerange(aes(ymin = y-1, ymax = y+1), position = "dodge")
# You need to explicitly specify the width for dodging
p + geom_linerange(aes(ymin = y-1, ymax = y+1),
  position = position_dodge(width = 0.9))

# Similarly with error bars:
p + geom_errorbar(aes(ymin = y-1, ymax = y+1), width = 0.2,
  position = "dodge")
p + geom_errorbar(aes(ymin = y-1, ymax = y+1, width = 0.2),
  position = position_dodge(width = 0.90))
}
}
\seealso{
Other position adjustments: 
\code{\link{position_fill}()},
\code{\link{position_identity}()},
\code{\link{position_jitterdodge}()},
\code{\link{position_jitter}()},
\code{\link{position_nudge}()}
}
\concept{position adjustments}
