% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-size.r
\name{scale_size}
\alias{scale_size}
\alias{scale_size_continuous}
\alias{scale_radius}
\alias{scale_size_discrete}
\alias{scale_size_area}
\alias{scale_size_datetime}
\alias{scale_size_date}
\title{Scale size (area or radius).}
\usage{
scale_radius(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  range = c(1, 6),
  trans = "identity",
  guide = "legend"
)

scale_size(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  range = c(1, 6),
  trans = "identity",
  guide = "legend"
)

scale_size_area(..., max_size = 6)
}
\arguments{
\item{name}{The name of the scale. Used as axis or legend title. If
\code{NULL}, the default, the name of the scale is taken from the first
mapping used for that aesthetic.}

\item{breaks}{One of: \itemize{
  \item \code{NULL} for no breaks
  \item \code{waiver()} for the default breaks computed by the
    transformation object
  \item A numeric vector of positions
  \item A function that takes the limits as input and returns breaks
    as output
}}

\item{labels}{One of: \itemize{
  \item \code{NULL} for no labels
  \item \code{waiver()} for the default labels computed by the
    transformation object
  \item A character vector giving labels (must be same length as \code{breaks})
  \item A function that takes the breaks as input and returns labels
    as output
}}

\item{limits}{A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum.}

\item{range}{a numeric vector of length 2 that specifies the minimum and
maximum size of the plotting symbol after transformation.}

\item{trans}{Either the name of a transformation object, or the
  object itself. Built-in transformations include "asn", "atanh",
  "boxcox", "exp", "identity", "log", "log10", "log1p", "log2",
  "logit", "probability", "probit", "reciprocal", "reverse" and "sqrt".

  A transformation object bundles together a transform, it's inverse,
  and methods for generating breaks and labels. Transformation objects
  are defined in the scales package, and are called \code{name_trans}, e.g.
  \code{\link[scales]{boxcox_trans}}. You can create your own
  transformation with \code{\link[scales]{trans_new}}.}

\item{guide}{Name of guide object, or object itself.}

\item{...}{Other arguments passed on to \code{\link{continuous_scale}}
to control name, limits, breaks, labels and so forth.}

\item{max_size}{Size of largest points.}
}
\description{
\code{scale_size} scales area, \code{scale_radius} scales radius. The size
aesthetic is most commonly used for points and text, and humans perceive
the area of points (not their radius), so this provides for optimal
perception. \code{scale_size_area} ensures that a value of 0 is mapped
to a size of 0.
}
\examples{
p <- ggplot(mpg, aes(displ, hwy, size = hwy)) +
   geom_point()
p
p + scale_size("Highway mpg")
p + scale_size(range = c(0, 10))

# If you want zero value to have zero size, use scale_size_area:
p + scale_size_area()

# This is most useful when size is a count
ggplot(mpg, aes(class, cyl)) +
  geom_count() +
  scale_size_area()

# If you want to map size to radius (usually bad idea), use scale_radius
p + scale_radius()
}
\seealso{
\code{\link{scale_size_area}} if you want 0 values to be mapped
  to points with size 0.
}
