% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pass.R
\name{pass}
\alias{pass}
\title{Detection of multivariate anomalous segments using PASS.}
\usage{
pass(x, alpha = 2, lambda = NULL, Lmax = 10, Lmin = 1, transform = robustscale)
}
\arguments{
\item{x}{An n x m real matrix representing n observations of m variates.}

\item{alpha}{A positive integer > 0. This value is used to stabilise the higher criticism based test statistic used by PASS leading to a better finite sample familywise error rate. 
Anomalies affecting fewer than alpha components will however in all likelihood escape detection.}

\item{lambda}{A positive real value setting the threshold value for the familywise Type 1 error. The default value
is \eqn{(1.1 {\rm log}(n \times Lmax) +2 {\rm log}({\rm log}(m))) / \sqrt{{\rm log}({\rm log}(m))}}.}

\item{Lmax}{A positive integer (\code{Lmax} > 0) corresponding to the maximum segment length. The default value is 10.}

\item{Lmin}{A positive integer (\code{Lmax} >= \code{Lmin} > 0) corresponding to the minimum segment length. The default value is 1.}

\item{transform}{A function used to transform the data prior to analysis. The default value is to scale the data using the median and the median absolute deviation.}
}
\value{
An S4 object of type \code{.pass.class} containing the data \code{X}, procedure parameter values, and the results.
}
\description{
Implements the PASS (Proportion Adaptive Segment Selection) procedure of Jeng et al. (2012). PASS uses a higher criticism statistic to pool the information about the 
presence or absence of a collective anomaly across the components. It uses Circular Binary Segmentation to detect multiple collective anomalies.
}
\examples{
library(anomaly)
# generate some multivariate data
set.seed(0)
sim.data<-simulate(n=500,p=200,mu=2,locations=c(100,200,300),
                   duration=6,proportions=c(0.04,0.06,0.08))
res<-pass(sim.data)
summary(res)
plot(res,variate_names=FALSE)

}
\references{
\insertRef{10.1093/biomet/ass059}{anomaly}
}
