% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeCluster.R
\name{remove-cluster}
\alias{remove-cluster}
\alias{removeCluster}
\alias{removeClusterRES}
\title{Remove a cluster}
\usage{
removeCluster(
  area,
  cluster_name,
  add_prefix = TRUE,
  opts = antaresRead::simOptions()
)

removeClusterRES(
  area,
  cluster_name,
  add_prefix = TRUE,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{area}{Area from which to remove a cluster.}

\item{cluster_name}{Cluster to remove.}

\item{add_prefix}{If \code{TRUE}, cluster_name will be prefixed by area's name.}

\item{opts}{List of simulation parameters returned by the function
\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
Remove a cluster, thermal or RES (renewable energy source), and all its data.
}
\examples{
\dontrun{
createCluster(area = "fr", cluster_name = "fr_gas",
              group = "other", `marginal-cost` = 50)

removeCluster(area = "fr", cluster_name = "fr_gas")

}
}
\seealso{
\code{\link[=createCluster]{createCluster()}} or \code{\link[=createClusterRES]{createClusterRES()}} to create new clusters, \code{\link[=editCluster]{editCluster()}} or \code{\link[=editClusterRES]{editClusterRES()}} to edit existing clusters.
}
